#ifndef SCREEM_SITE_H
#define SCREEM_SITE_H

#include "page.h"
#include "todo.h"

#include <glib.h>
#include <gnome-xml/debugXML.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

typedef gpointer Site;

Site* screem_site_new( void );
void screem_site_destroy( Site *site );

void screem_site_purge( Site *site );

void screem_site_set_name( Site *site, const gchar *name );
const gchar* screem_site_get_name( Site *site );

void screem_site_set_pathname( Site *site, const gchar *pathname );
const gchar* screem_site_get_pathname( Site *site );

void screem_site_set_remote_url( Site *site, const gchar *remote_url );
const gchar* screem_site_get_remote_url( Site *site );

void screem_site_set_remote_method( Site *site, const gchar *remote_method );
const gchar* screem_site_get_remote_method( Site *site );

void screem_site_set_remote_path( Site *site, const gchar *remote_path );
const gchar* screem_site_get_remote_path( Site *site );

void screem_site_set_remote_user( Site *site, const gchar *remote_user );
const gchar* screem_site_get_remote_user( Site *site );

void screem_site_set_remote_pass( Site *site, const gchar *remote_pass );
const gchar* screem_site_get_remote_pass( Site *site );

void screem_site_set_cvs_root( Site *site, const gchar *cvs_root );
const gchar* screem_site_get_cvs_root( Site *site );

void screem_site_set_use_cvs( Site *site, gboolean status );

void screem_site_set_template_path( Site *site, const gchar *template_path );
const gchar* screem_site_get_template_path( Site *site );

void screem_site_set_use_template( Site *site, gboolean status );

void screem_site_set_http_url( Site *site, const gchar *http_url );
const gchar* screem_site_get_http_url( Site *site );

void screem_site_set_current_page( Site *site, Page *page );
Page *screem_site_get_current_page( Site *site );

void screem_site_set_is_import( Site *site, gboolean val );
gboolean screem_site_get_is_import( Site *site );

void screem_site_set_open_pages( Site *site, gint num );
gint screem_site_get_open_pages( Site *site );

#define screem_site_inc_open_pages( s ) \
screem_site_set_open_pages( s, screem_site_get_open_pages( s ) + 1 )
#define screem_site_dec_open_pages( s ) \
screem_site_set_open_pages( s, screem_site_get_open_pages( s ) - 1 )

void screem_site_save( Site *site );
gboolean screem_site_create( Site *site );
gboolean screem_site_load( Site *site );

gboolean screem_site_write_project_file( Site *site );
gboolean screem_site_parse_project_file( Site *site, xmlDocPtr doc );

Page* screem_site_locate_page( Site *site, const gchar *path );
void screem_site_add_page( Site *site, const gchar *path );
Page* screem_site_remove_page( Site *site, const gchar *path );
GList* screem_site_get_pages( Site *site );

Todo_item* screem_site_locate_task( Site *site, const gchar *task );
void screem_site_add_task( Site *site, Todo_item *item );
Todo_item* screem_site_remove_task( Site *site, const gchar *task );
GList* screem_site_get_tasks( Site *site );

void screem_site_file_change( Site *site, gchar *src, gchar *dest );

#endif
