<?php
#
# Copyright (c) 1999 Internet Images srl
#                    Massimiliano Masserelli
#
# $Id: wizard.inc,v 1.1 1999/11/02 11:11:15 negro Exp $
#
 class Wizard {
   var $classname = "Wizard";
   var $persistent_slots = array("items", "wizard_values", "form_values");
   
   var $items = array();
   var $wizard_values = array();
   var $form_values = array();
   var $CF;

   function start() {
     global $sess;

     $sess->register("wizard");
   }

   function add_item($wizard_form) {
     $this->items[] = $wizard_form;
   }
   
   function clear() {
     $this->wizard_values = array();
     return $this->items[0];
   }

   function back($CFN) {
     $ci = -1;
     for ($i = 0; $i < sizeof($this->items); $i++) {
       if ($this->items[$i] == $CFN) {
         $ci = $i;
       }
     }
     if (empty($CFN)) {
       $ci = sizeof($this->items);
     }
     if ($ci == -1) {
       print "Error: back()!";
       return false;
     } 
     for ($ci = $ci -1; $ci >= 0; $ci--) {
       $CFN = $this->items[$ci];
       $this->CF = new $CFN;
       $this->CF->init($this->wizard_values);
       $this->wizard_values = $this->CF->get_values_clear();
       if (! $this->CF->get_values() ) {
       	 break;
       }
     }
     $this->CF->set_default_values($this->form_values[$CFN]);
     return $this->items[$ci];
   }


   function next($CFN) {
     $ci = -1;
     for ($i = 0; $i < sizeof($this->items); $i++) {
       if ($this->items[$i] == $CFN) {
         $ci = $i;
       }
     }
     if ($ci == -1) {
       print "Error: next()!";
       return false;
     } 
     $rv = "";
     for ($ci; $ci < sizeof($this->items); $ci++) {
       $CFN = $this->items[$ci];
       $this->CF = new $CFN;
       $this->CF->init($this->wizard_values);
       if (! ($values = $this->CF->get_values()) ) {
         $rv = $CFN;
         break;
       } else {
         $this->wizard_values = $values; 
         $this->form_values[$CFN] = $this->CF->get_default_values();
       }
     }
     return $rv;
   }

   function display($CFN) {
     if (empty($CFN)) {
       $this->finish();
       return 1;
     }
     $ci = -1;
     for ($i = 0; $i < sizeof($this->items); $i++) {
       if ($this->items[$i] == $CFN) {
         $ci = $i;
       }
     }
     if ($ci == -1) {
       print "Error: display()!";
       return false;
     } 
     if ((! is_object($this->CF)) || ($this->CF->classname != $CFN)) {
       $this->CF = new $CFN;
       $this->CF->init($this->wizard_values);
     }
     $this->CF->display();
   }
   
   function show_steps() {
     include("WF_Steps.ihtml");
     return true;
   }

   function finish() {
     include("Finish.ihtml");
   }
 }
?>
