<?php

/*
  
  File: menu.php3
  $Author: chuck $
  $Revision: 2.3.2.4 $
  $Date: 2000/01/06 02:17:30 $
  
  Horde: Copyright 1999 Charles J. Hagenbuch  <chuck@horde.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/

/* Initialize everything if we haven't already */
if (!defined("HORDE_LIB")) include './lib/horde.lib';
require './config/horde.php3';

/* Html styles configuration */
require './config/html.php3';

$language = select_lang();
require "./locale/$language/menu.lang";
require "./locale/local/menu.lang";

error_reporting($default->error_level);

function set_menu ($text) {
  /* skip any comment lines */
  if (preg_match("|([^#]*)#.*|", $text, $regs)) {
    if (isset($regs[1]))
      $text = $regs[1];
    else
      $text = '';
    
    /* If there was something before the comment, make it a complete line */
    if (strlen($text) > 0) {
      $text = $text . "\n";
    }
  }
  
  if (preg_match("|(.*)<(.*)>(.*)|", $text, $regs)) {
    $text = "<br><a href=\"" . $regs[1] . "\" target=\"_blank\"><img border=\"0\" hspace=\"2\" align=\"middle\" src=\"./graphics/" . $regs[3] . "\" width=\"18\" height=\"18\" alt=\"*\">" . $regs[2] . "</a>\n";
  }
  return $text;
}

$extra_menus = '';
$menu_array = @file('./config/menu.txt');
for ($j = 0; $j < count($menu_array); $j++) {
  $extra_menus .= set_menu($menu_array[$j]);
}

if (!isset($menu)) $menu = HORDEMENU_DORMANT;

$dark_theme = true;
require "$default->horde_include_dir/doctype.inc";
require "$default->horde_include_dir/generic-header.inc";
if ($menu != HORDEMENU_BLANK) {
  include "$default->horde_include_dir/menu/menu.inc";
}
require "$default->horde_include_dir/generic-footer.inc";

?>
