package HNS::Calendar::Table;
################################################################
# HNS::Calendar::Table;
#
# usage:
#  my $cal = new HNS::Calendar::Table(year=>$y, month=>$m, col=>$col);
#  print $cal->AsHTML;
#
# $Id: Table.pm,v 1.9.2.1 1999/10/20 14:00:22 kenji Exp $
################################################################
use strict;
use ObjectTemplate;
use vars qw(@ISA $TableBorder @WeekString $NextTemplate $PrevTemplate
	    $ThisTemplate $DayCurrentTemplate $DayNonCurrentTemplate);
@ISA = qw(ObjectTemplate);

attributes qw();

use Time::Local;
use DateTime::Date;
use HNS::Collection;
use HNS::Template;
use HNS::System;

################################################################
$TableBorder = 0;
#$WeekStringType = 'ABBR';
@WeekString = ('Sun', 'Mon', 'Tue', 'Wed', 'Thr', 'Fri', 'Sat');
#@WeekString = @{$DateTime::Date::WeekString{'ABBR'}};
$NextTemplate = qq(<a href="?%year%month">Next</a>);
$PrevTemplate = qq(<a href="?%year%month">Prev</a>);
$ThisTemplate = qq(<a href="?%year%month">%year/%month</a>);
$DayCurrentTemplate = qq(<a href="%ruri#%{ymd}0">%day</a>);
$DayNonCurrentTemplate = qq(<a href="./?%year%month%high#%{ymd}0">%day</a>);

################################################################
sub AsHTML ($$$$)
{
    my ($self, $year, $month, $col) = @_;
    ($year, $month) = (sprintf("%04d", $year), sprintf("%02d", $month));
    my $html;
    my $templ = new HNS::Template;
    
    # table start
    $html .= qq(<table border="$TableBorder" summary="calendar">\n);
    # month
    my $date = new DateTime::Date(year=>$year, month=>$month, day=>1);
    $date -= '1M';
    $html .= "<tr>\n";
    # prev
    $html .= qq(<th colspan="2" align="left">);
    $html .= $templ->Expand($PrevTemplate,
			    {year=>$date->year,
			     month=>sprintf("%02d", $date->month)});
    $html .= "</th>\n";
    # this month
    $date += '1M';
    $html .= qq(<th colspan="3" align="center">);
    $html .= $templ->Expand($ThisTemplate,
			    {year=>$date->year,
			     month=>sprintf("%02d", $date->month)});
    $html .= "</th>\n";
    # next
    $date += '1M';
    $html .= qq(<th colspan="2" align="right">);
    $html .= $templ->Expand($NextTemplate,
			    {year=>$date->year,
			     month=>sprintf("%02d", $date->month)});
    $date -= '1M';
    $html .= "</th>\n";
    # week
    $html .= "<tr>\n";
    for (0..6){
	$html .= "<th align=\"center\">" .
#	    $DateTime::Date::WeekString{uc($WeekStringType)}->[$_] .
	    $WeekString[$_] .
		"</th>\n";
    }
    # day
    # null space
    my $start_week = $date->week;
    if ($start_week){
        $html .= "\n<tr>";
    }
    my $day = 1;
    for my $i (1..$start_week){
	$html .= "<td></td>";
    }
    $html .= "\n";
    # 1..31
    for $day (1..$date->DaysMonth){
	if (($day+$start_week)%7-1 == 0){
	    $html .= qq(<tr>\n);
	}
	$html .= qq(<td align="right">);
	my $ymd = sprintf("%04d%02d%02d", $year, $month, $day);
	if ($col->diarys->{$ymd}){
	    my $high = int($day/10);
	    my $abc;
	    if ($day < 11) {
		$abc = "a";
	    }
	    elsif ($day < 21) {
		$abc = "b";
	    }
	    else {
		$abc = "c";
	    }
	    if ($col->diarys->{$ymd}->read_done){
#		$html .= sprintf($DayCurrentTemplate,
#				 $ENV{'REQUEST_URI'}, 
#				 $year, $month, $day, $day);
		$html .= $templ->Expand($DayCurrentTemplate,
				{ruri=>$ENV{'REQUEST_URI'}, year=>$year,
				 month=>$month, day=>$day, ymd=>$ymd});
	    } else {
#		$html .= sprintf($DayNonCurrentTemplate,
#				 $year, $month, $high,
#				 $year, $month, $day, $day);
		$html .= $templ->Expand($DayNonCurrentTemplate,
				{year=>$year, month=>$month, high=>$high,
				 abc=>$abc, day=>$day, ymd=>$ymd});
	    }
	} else {
	    $html .= qq($day);
	}
	$html .= qq(</td>\n);
    }
    $html .= qq(</table>);
}
1;

