# $Id: QueryString.pm,v 1.2 1999/04/17 18:04:38 kenji Exp $
package CGI::QueryString;
################################################################

use strict;
use Exporter;
use vars qw(@ISA @EXPORT $QueryString %Parameter);
@ISA = qw(Exporter);
@EXPORT = qw(query_string param);

BEGIN{
    my $method = $ENV{'REQUEST_METHOD'};
    
    if ($method =~ /^(GET|HEAD)$/){
	$QueryString = $ENV{'QUERY_STRING'};
    } elsif ($method eq 'POST'){
	read(STDIN, $QueryString, $ENV{'CONTENT_LENGTH'});
    } else {                # command line
	$QueryString = join('&', @ARGV);
    }
    for (split("&", $QueryString)){
	my ($key, $value) = split("=");
	if (defined $value){
	    $Parameter{$key} = $value;
#	    print "$key, $value : $Parameter{$key} ";
	} else {
	    $Parameter{keywords} = $key;
	}
    }
}
################################################################
sub query_string()
{
    return $QueryString;
}
sub param($)
{
    my $key = shift;
#    print "param($key):$Parameter{$key}";
    my $value = $Parameter{$key};
    $value =~ tr/+/ /;       # pluses become spaces
    $value =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
    return $value;
}
1;
