#ifndef __BWINDOW_H__
#define __BWINDOW_H__

#include <gdk/gdk.h>
#include <gtk/gtkwindow.h>

#include "history.h"
#include "url.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define BWINDOW(obj)          GTK_CHECK_CAST (obj, bwindow_get_type (), BWindow)
#define BWINDOW_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, bwindow_get_type (), BWindowClass)
#define IS_BWINDOW(obj)       GTK_CHECK_TYPE (obj, bwindow_get_type ())


typedef struct _BWindow       BWindow;
typedef struct _BWindowClass  BWindowClass;

struct _BWindow
{
  GtkWindow window;
  
  GtkWidget *urlentry;
  GtkWidget *hdrtext;
  GtkWidget *browser;
  GtkWidget *status;

  GtkWidget *backbutton;
  GtkWidget *forwardbutton;
  GtkTooltips *backtooltips;
  GtkTooltips *forwardtooltips;

  GtkWidget *backmenu;
  GtkWidget *forwardmenu;

  GtkWidget *filesel;

  GtkWidget *tb1, *tb2; /* toolbars */

  HistoryNode *history;

  URL *current;
#if 0
  url_ds *url;
  url_data loc; /* location: topmost url */
#endif

};

struct _BWindowClass
{
  GtkVBoxClass parent_class;

  void (* bwindow) (BWindow *ttt);
};

guint          bwindow_get_type        (void);
GtkWidget*     bwindow_new             (void);
void           bwindow_clear           (BWindow *b);
void           bwindow_set_status      (BWindow *bwindow, char *str);
int            bwindow_set_url         (BWindow *b, char *url);
char *         bwindow_get_url         (BWindow *b);
int            history_change          (BWindow *bwindow, HistoryNode *history);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __BWINDOW_H__ */
