/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1998-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#ifndef _SETS_H_
#define _SETS_H_

#include <limits.h>

  // support 8-bit chars set
  class CharSet
  {
    char data[UCHAR_MAX+2]; // +1 for `0' and +1 for the last `0' for `const char*' converison

    public:

    CharSet() { delall(); };
    CharSet( const char* str ) { delall(); set( str ); };
    CharSet( char ch ) { delall(); set( ch ); };
    operator const char* () { return (char*)(&data[0]); };
    friend CharSet operator + ( const CharSet& set1, const CharSet& set2 );
    void setall();
    void delall();
    void set( const char* str );
    void set( char ch );
    void setr( char start, char end ); // set range
    int get( const char *str ); // return 1 if all str's chars are in the set
    int get( char ch ); // return 1 if `ch' is in the set
    void del( const char* str );
    void del( char ch );
    void delr( char start, char end ); // del range

    int in( int pos ); // this can check outrange
  };

#endif //_SETS_H_

 // eof sets.h
