/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#include "vfu.h"
#include "vfuuti.h"
#include "vfumenu.h"
#include "vfusys.h"
#include "vfudir.h"
#include "vfuopt.h"
#include "vfuview.h"

int UpdateShellStr( const char * pS, char * pD, char *Options )
{
String str;
pD[0] = 0;

int iz = 0;
int oz = 0;

// toggles
#ifdef _TARGET_GO32_
int use_SFN = 0;
int use_BS  = 0; // backslashes
if (opt.DOSSlashes) use_BS = 1;
#endif

while(pS[iz])
  if (pS[iz] == '%')
    {
    pD[oz] = 0;
    switch(pS[iz+1])
      {
      #ifdef _TARGET_GO32_
      case '_' : use_SFN = 1; break;
      case '\\' : use_BS = 1; break;
      #endif
      case 'r' :
      case 'R' : strcat( Options, "R" ); break; // refresh all files after (readdir)
      case 'f' : // file name
      case 'F' : if (FilesCount > 0 && WorkMode == wmInArchive)
                   {
                   strcat( pD, Files[FLI]->name );
                   }
                 else
                 if (FilesCount > 0)  // expanded (path) file name
                   {
                   str = Files[FLI]->name;
                   if (pS[iz+1] == 'F') str = CPath + str;
                   #ifdef _TARGET_GO32_
                   if (use_SFN)
                     {
                     get_sfn( str, sss );
                     str = sss;
                     }
                   #endif
                   if ( StrCount( str, " {}" ) > 0 ) str = "\"" + str + "\"";
                   #ifdef _TARGET_GO32_
                   if ( use_BS ) StrTR( str, "/", "\\" );
                   #endif
                   strcat(pD, str);
                   }
                 oz = strlen(pD);
                 break;

      case 'e' : // name only
      case 'E' : // extension only
                 str = Files[FLI]->name;
                 if ( pS[iz+1] == 'e' )
                   FileName( Files[FLI]->name, sss );
                 else
                   FileExt( Files[FLI]->name, sss );
                 strcat(pD, sss);
                 oz = strlen(pD);
                 break;

     // file size
     case 's'  : sprintf( sss, "%f", Files[FLI]->size );
                 strcat( pD, sss);
                 oz = strlen(pD);
                 break;

      case '?' : say1("Enter parameter:");
                 sss[0] = 0;
                 if (GetStr( sss, HID_SHELL_PAR ))
                   strcat(pD, sss);
                 else
                   return 3;
                 say1( " " );
                 say2( " " );
                 oz = strlen(pD);
                 break;
      case 'd' : say1("Enter directory:");
                 if (GetDirName( "", "", 0 ))
                   strcat(pD, TargetDir);
                 else
                   return 3;
                 say1( " " );
                 say2( " " );
                 oz = strlen(pD);
                 break;

      case 'c' : // current path
                 str = CPath;
                 #ifdef _TARGET_GO32_
                 if ( use_BS ) StrTR( str, "/", "\\" );
                 #endif
                 strcat( pD, str.asis() );
                 oz = strlen(pD);
                 break;

      case 'C' : // startup dir
                 str = SD;
                 #ifdef _TARGET_GO32_
                 if ( use_BS ) StrTR( str, "/", "\\" );
                 #endif
                 strcat( pD, str.asis() );
                 oz = strlen(pD);
                 break;

      case 'A' : // Archive name
                 strcat( pD, AName );
                 oz = strlen(pD);
                 break;

      case 'w' :
      case 'W' : strcat( Options, "w" ); break;
      case 'i' : strcat( Options, "i" ); break;
      case 'n' : strcat( Options, "n" ); break;
      default: pD[oz] = pS[iz+1]; oz++; break;
      }
    iz += 2;
    }
  else
    {
    pD[oz] = pS[iz];
    iz++;
    oz++;
    pD[oz] = 0;
    }
pD[oz] = 0;
return 0;
}

////////////////////////////////////////////////////////////////////////////
//
//
//

int BreakOp()
{
  if (ConKbHit())
    if (ConGetch() == 27)
      {
      say2( "Press ENTER to cancel or other key to continue..." );
      int key = ConGetch();
      say2( "" );
      if ( key == 13 )
        {
        return 1;
        }
      }
  return 0;
}

////////////////////////////////////////////////////////////////////////////
//
//
//

fsize_t CalcSelSize( int one ) // used before copy/move to calc estimated size
{
  fsize_t size = 0;
  int z;
  for(z = 0; z < FilesCount; z++ )
    if ((Files[z]->sel && one == 0) || (z == FLI && one == 1))
      {
      TF *fi = Files[z];
      if (!fi->is_link) // symlinks have not size ?
        if (fi->is_dir && fi->size == -1)
          {
          fi->size = DirSize( fi->name );
          size += fi->size;
          }
        else
          size += fi->size;
      }
  return size;
}

////////////////////////////////////////////////////////////////////////////
//
//
//

int IsFileRO( const char* fname ) // read only?
{
  #ifdef _TARGET_GO32_
  attrs_t attrs;
  if (fgetattr_s( fname, attrs )) return 0; // getattr failed -- not RO
  return (attrs[6] != '-');
  #endif

  #ifdef _TARGET_UNIX_
  return 0;
  #endif

  #ifdef _TARGET_UNKNOWN_
  return 0;
  #endif

  return 0;
}

////////////////////////////////////////////////////////////////////////////
//
//
//

char* SimplifyPath( const char* path, char* dest ) // removes ".."s
{
  if ( path != NULL ) strcpy( dest, path );
  StrReplace( dest, "/./", "/" );
  int i = -1;
  while( (i = StrFind( dest, "/../" ) ) != -1 )
    {
    int j = i - 1;
    while( j > 0 && dest[j] != '/' ) j--;
    StrDelete( dest, j+1, i+3-j );
    }
  return dest;
}

////////////////////////////////////////////////////////////////////////////
//
//
//

int Ask( const char *prompt, const char *allowed, int line )
{
  int ch = 1;
  if (line == 1)
    say1( prompt );
  else
    say2( prompt );
  while ( strchr( allowed, ch ) == NULL ) ch = ConGetch();
  return ch;
}

////////////////////////////////////////////////////////////////////////////
//
//
//
char* ExpandMask( char* mask )
{
  if ( StrCount( mask, "*?" ) > 0 ) return mask;
  strcat( mask, "*" );
  if ( mask[0] == '.' ) StrInsert( mask, 0, "*" );
  StrReplace( mask, "**", "*" );
  return mask;
}
////////////////////////////////////////////////////////////////////////////
//
//
//
  char* TimeStr( const time_t tim, char* buf )
  {
    ASSERT( buf );
    time_t timenow = time( NULL );
    strcpy(buf, ctime(&tim));
    if (timenow > tim + 6L * 30L * 24L * 60L * 60L /* Old. */
        ||
        timenow < tim - 60L * 60L) /* In the future. */
        strcpy (buf + 11, buf + 19);
    buf[16] = 0;
    strcpy(buf, buf+4);
    // strcpy(stctime+3, stctime+4);
    if (buf[4] == ' ') buf[4] = '0';
    return buf;
  }

////////////////////////////////////////////////////////////////////////////
//
//
//
void Beep()
{
  if ( opt.AllowBeep ) { ConBeep(); }
}

////////////////////////////////////////////////////////////////////////////
//
//
//

#ifdef _TARGET_GO32_

//
// This is specific to djgpp/libc 2.01 -- if it changes later this
// must be changed too...
//

struct ___DIR {
  int num_read;
  char *name;
  int flags;
  struct ffblk ff;
  struct dirent de;
  int need_fake_dot_dotdot; /* 0=no, 1=.., 2=. */
};

/* Convert file date and time to time_t value suitable for
   struct stat fields.  */
time_t _file_time_stamp(unsigned int dos_ftime)
{
  struct tm file_tm;
  memset(&file_tm, 0, sizeof(struct tm));
  file_tm.tm_isdst = -1;    /* let mktime() determine if DST is in effect */
  file_tm.tm_sec  = (dos_ftime & 0x1f) * 2;
  file_tm.tm_min  = (dos_ftime >>  5) & 0x3f;
  file_tm.tm_hour = (dos_ftime >> 11) & 0x1f;
  file_tm.tm_mday = (dos_ftime >> 16) & 0x1f;
  file_tm.tm_mon  = ((dos_ftime >> 21) & 0x0f) - 1; /* 0 = January */
  file_tm.tm_year = (dos_ftime >> 25) + 80;
  return mktime(&file_tm);
}

int dosstat( DIR *dir, struct stat *statbuf )
{
  #define ff_blk (((___DIR*)(dir))->ff)

  #define READ_ACCESS     (S_IRUSR | S_IRGRP | S_IROTH)
  #define WRITE_ACCESS    S_IWUSR
  #define EXEC_ACCESS     (S_IXUSR | S_IXGRP | S_IXOTH)

  memset(statbuf, 0, sizeof(struct stat));

  unsigned dos_ftime = 0;
  dos_ftime = ( (unsigned short)ff_blk.ff_fdate << 16 ) +
                (unsigned short)ff_blk.ff_ftime;

  statbuf->st_uid     = getuid();
  statbuf->st_gid     = getgid();
  statbuf->st_nlink   = 1;
  statbuf->st_size    = ff_blk.ff_fsize;
  statbuf->st_mode   |= READ_ACCESS;
  if ( !(ff_blk.ff_attrib & 0x07) )  /* no R, H or S bits set */
     statbuf->st_mode |= WRITE_ACCESS;
  if (ff_blk.ff_attrib & 0x10)
     statbuf->st_mode |= (S_IFDIR | EXEC_ACCESS);
  /* Set regular file bit.  */
  statbuf->st_mode |= S_IFREG;

  /* Time fields. */
  statbuf->st_atime = statbuf->st_mtime = statbuf->st_ctime =
    _file_time_stamp(dos_ftime);

  if ( ! strcmp(ff_blk.lfn_magic,"LFN32") )
    {
      unsigned xtime;
      xtime = *(unsigned *)&ff_blk.lfn_ctime;
      if(xtime)                 /* May be zero if file written w/o lfn active */
        statbuf->st_ctime = _file_time_stamp(xtime);
      xtime = *(unsigned *)&ff_blk.lfn_atime;
      if(xtime > dos_ftime)     /* Accessed time is date only, no time */
        statbuf->st_atime = _file_time_stamp(xtime);
    }

  return 0;
  #undef ff_blk
}
#endif

////////////////////////////////////////////////////////////////////////////
//
//
//
int PathSplit( const char *target, const char *delimiters, pathstr_t result[], int maxresults )
{
  int z = 0; // target index
  int i = 0; // result index
  int j = 0; // result[i] index
  result[i][0] = 0;
  while(1)
    {
    if (strchr( delimiters, target[z] ))
      {
      result[i][j] = 0;
      j = 0;
      i++;
      if (maxresults != -1 && i == maxresults ) break;
      while (strchr( delimiters, target[z] ) && target[z] != 0) z++;
      }
    else
      {
      result[i][j] = target[z];
      j++;
      z++;
      }
    if (target[z] == 0)
      {
      result[i][j] = 0;
      i++;
      break;
      }
    }
  result[i][0] = 0;
  return i;
}

////////////////////////////////////////////////////////////////////////////
//
//
//
char* UpString( char *s )
{
  int sl = strlen( s );
  int z = 0;
  for(z = 0; z < sl; z++) s[z] = toupper(s[z]);
  return s;
};

char* LowString( char *s )
{
  int sl = strlen( s );
  int z = 0;
  for(z = 0; z < sl; z++) s[z] = tolower(s[z]);
  return s;
};
///////////////////////////////////////////////////////////////////////////
// FILENAMES functions
/*
char* FixPath( char* s, int slashtype = '/' ) // adds trailing '/' if not exist
{
  size_t sl = strlen( s );
  if ( s[sl-1] != slashtype )
    {
    s[sl] = slashtype;
    s[sl+1] = 0;
    }
}

char* FileExt( const char *pS, char *Ext ) // returns extension
{
Ext[0] = 0;
int len = strlen(pS);
int z = len - 1;
while (pS[z] != '.' && pS[z] != '/' && z > 0) z--;
if (pS[z] == '.')
  if (!(z == 0 || (z > 0 && pS[z-1] == '/'))) // it is ".filename" --> no ext;
    strcpy( Ext, pS + z + 1 );
  return Ext;
}

char* FileName( const char *pS, char *Name ) // returns file name only (w/o ext)
{
  int len = strlen(pS);
  int z = len - 1;

  while ( pS[z] != '/' && z >= 0) z--;
  strcpy( Name, pS + z + 1 );

  z = strlen( Name ) - 1;
  while (Name[z] != '.' && Name[z] != '/' && z > 0) z--;
  if (Name[z] == '.')
    Name[z] = 0;
  return Name;
}

char* FileNameExt( const char *pS, char *Path ) // returns file name (w. ext)
{
  int len = strlen(pS);
  int z = len - 1;

  while ( pS[z] != '/' && z >= 0) z--;
  strcpy( Path, pS + z + 1 );

  return Path;
}

char* FilePath( const char *pS, char *Path ) // returns file name path (w. trailing '/')
{
  int len = strlen(pS);
  int z = len - 1;
  strcpy( Path, pS );

  while ( Path[z] != '/' && z > 0) z--;
  if (Path[z] == '/')
    Path[z+1] = 0;
  return Path;
}
*/
int PathCmp( const char* s1, const char* s2 ) // uses strcmp under linux and strcasecmp uder dos
{
  #ifdef _TARGET_GO32_
  return strcasecmp( s1, s2 );
  #else
  return strcmp( s1, s2 );
  #endif
}

int PathNCmp( const char* s1, const char* s2, int len ) // uses strncmp under linux and strncasecmp uder dos
{
  #ifdef _TARGET_GO32_
  return strncasecmp( s1, s2, len );
  #else
  return strncmp( s1, s2, len );
  #endif
}

////////////////////////////////////////////////////////////////////////////
//
//
//
/*
  void AddHist10( const char* ps, THist10 hist, int nocase )
  {
    if ( !ps[0] ) return;
    int z = 0;
    int from = 0;
    for( from = 0; from < 10; from++)
      if( (nocase?strcasecmp(ps, hist[from]):strcmp(ps, hist[from])) == 0) break;
    if (from == 10) from--;
    for (z = from; z > 0; z--)
      strcpy(hist[z], hist[z-1]);
    strcpy(hist[0], ps);
  };

  int MenuHist10( int x, int y, const char* title, THist10 hist, int firsthotkey )
  {
    int z = 0;
    mb.freeall();
    for ( z = 0; z < 10; z++ )
      {
      sprintf(sss, "%d %s", (z)%10, hist[z]);
      if ( z == 0 && firsthotkey )
        sss[0] = firsthotkey;
      mb.add(sss);
      }
    return MenuBox( x, y, title );
  };
*/
////////////////////////////////////////////////////////////////////////////
//
//
//

// the following pszview function is subject to change --

void SetMenuColors()
{
  PSZViewCN = 23;
  PSZViewCH = 47;
  PSZViewTI = 95; // title
}

int MenuBoxExitCh  = 0;
int MenuBoxExitKey = 0;
PSZCluster mb;
char PSZViewBorder[32] = ".-.|'-`|";
int PSZViewCN = 23;
int PSZViewCH = 47;
int PSZViewTI = 95; // title
int PSZViewWrap = 0;
int PSZViewPos = 0;
int PSZViewClearBackground = 1;

char PSZViewConfirm[64] = "";
char PSZViewCancel[64] = "";
char PSZViewIgnore[64] = "";

int PSZView( int x, int y, int w, int h, const char *title, PSZCluster *sc, int hotkeys = -1 )
{
  TScrollPos scroll;
  int z;

  if (w == -1) w = (int)sc->maxlen();
  if (h == -1) h = sc->count();

  z = strlen(title);
  if (w < z) w = z;
  if (h > sc->count()) h = sc->count();
  if (h == 0) h = 1;

  String str;
  String exits = "";
  if ( hotkeys > -1 )
    {
    for(z = 0; z < sc->count(); z++)
      if (strncmp("--", sc->get(z), 2))
        StrAddCh( exits,int((const char*)(sc->get(z))[hotkeys]) );
      else
        StrAddCh( exits,' ' );
    StrUpCase(exits);
    }
  ConXY(x,y);
  int ch = 0;
  if (PSZViewClearBackground)
    if (!opt.AltMenus) // border
      {
      str = title;
      StrPad( str, -(w), '-' );
      str = ".-" + str + "-.";
      ConOut(x,y,str,PSZViewCN);

      str = "";
      StrPad( str, -(w), '-' );
      str = "`-" + str + "-'";
      ConOut(x,y+(h+2)-1,str,PSZViewCN);

      str = "";
      StrPad( str, -(w), ' ' );
      if (str.len() > w) StrSLeft(str,w);
      str = "| " + str + " |";
      for(z = 1; z < (h+2)-1; z++)
        ConOut(x,y+z,str,PSZViewCN);
      }
    else
      {
      str = "";
      str = title;
      StrPad( str,-(w), ' ');
      if (str.len() > w) StrSLeft(str,w);
      str = " " + str + " ";
      ConOut(x,y,str,PSZViewTI);
      }
  if (!opt.AltMenus) // border
    {
    x++; y++;
    }
  else
    {
    y++;
    }
  PSZViewClearBackground = 1;
  if ( PSZViewConfirm[0] == 0 ) strcpy( PSZViewConfirm, "\r" );
  if ( PSZViewCancel[0]  == 0 ) strcpy( PSZViewCancel , "\033" );
  if ( PSZViewIgnore[0]  == 0 ) strcpy( PSZViewIgnore , " " );

  scroll.settype(1);
  scroll.setwrap(PSZViewWrap);
  scroll.min = 0;
  scroll.max = sc->count()-1;
  scroll.pagesize = h;
  scroll.pos = 0;
  scroll.page = 0;
  scroll.gotopos(PSZViewPos);
  PSZViewPos = 0;

  int retpos = 0;
  while(1)
    {
    for( z = 0; z < scroll.pagesize; z++ )
      {
      if (scroll.page+z >= sc->count())
        str = "~";
      else
        str = sc->get(scroll.page+z);
      if ( strncmp("--", str, 2) )
        {
        StrPad( str,-w );
        if (str.len() > w) StrSLeft(str,w);
        str = " " + str + " ";
        }
      else
        {
        StrPad( str,-w , '-');
        if (str.len() > w) StrSLeft(str,w);
        str = " " + str + " ";
        }
      ConOut( x, y+z, str, ( scroll.page+z != scroll.pos ) ? PSZViewCN : PSZViewCH );
      }
    ch = ConGetch();
    if ( ch >= 0 && ch <= 255 && strchr( PSZViewIgnore, ch )) continue;
    MenuBoxExitCh = ch;
    if ( ch == KEY_UP ) scroll.up();
    if ( ch == KEY_DOWN ) scroll.down();
    if ( ch == KEY_NPAGE ) scroll.pagedown();
    if ( ch == KEY_PPAGE ) scroll.pageup();

    if ( ch >= 0 && ch <= 255 && strchr( PSZViewCancel, ch ))
      {
      MenuBoxExitKey = ch;
      retpos = -1;
      break;
      };
    if ( ch >= 0 && ch <= 255 && strchr( PSZViewConfirm, ch ))
      {
      if (strncmp("--", sc->get(scroll.pos), 2)) // ako e "--" e separator
        {
        MenuBoxExitCh = toupper( int((const char*)(sc->get(scroll.pos))[hotkeys]) );
        MenuBoxExitKey = ch;
        retpos = scroll.pos;
        break;
        }
      }
    z = -1;
    if ( ch > 0 && ch < 255 )
      if ((z = StrFind( exits,toupper(ch) )) > -1)
        {
        MenuBoxExitCh  = toupper(ch);
        MenuBoxExitKey =  toupper(ch);;
        retpos = z;
        break;
        }
    }

  strcpy( PSZViewConfirm, "\r" );
  strcpy( PSZViewCancel , "\033" );
  strcpy( PSZViewIgnore , " " );
  return retpos;
}

////////////////////////////////////////////////////////////////////////////
//
// ftwalk...
//

int __walk_dir(char *path, int (*func)(const char *, struct stat *, int), int level )
{
  DIR *dp;
  struct dirent *de;
  struct stat stbuf;
  int flag;
  int e = errno;
  int pathlen = strlen(path);

  if ( level != -1 && level == 0) return 1;

  if ((dp = opendir(path)) == 0) return -1;

  if (BreakOp()) return -1;

  for (errno = 0; (de = readdir(dp)) != 0; errno = 0)
    {
      int func_result;
      if ( strcmp( de->d_name, "." ) == 0 || strcmp(de->d_name, "..") == 0 ) continue;
/*
      if (de->d_name[de->d_namlen - 1] == '.')  continue;
      if (pathlen + de->d_namlen + 1 > FILENAME_MAX)
        {
          closedir(dp);
          errno = ENAMETOOLONG;
          return -1;
        }
*/
      if (path[pathlen-1] == '/' || path[pathlen-1] == '\\') pathlen--;
      path[pathlen] = '/';
      strcpy(path + pathlen + 1, de->d_name);

      lstat(path, &stbuf);
      int is_link = S_ISLNK( stbuf.st_mode );
      #ifdef _TARGET_GO32_
      if (dosstat(dp, &stbuf) < 0) // however -- dosstat will never return !=0
      #else
      if (stat(path, &stbuf) < 0)
      #endif
        flag = FTWALK_NS;
      else if (S_ISDIR(stbuf.st_mode))
        flag = FTWALK_D;
/*
      else if (S_ISLABEL(stbuf.st_mode))
        flag = FTWALK_VL;
*/
      else
        flag = FTWALK_F;
      if (is_link) flag += FTWALK_L;

      /* Invoke FUNC() on this object.  */
      errno = e;
      if ((func_result = (*func)(path, &stbuf, flag)) != 0)
        {
          closedir(dp);
          return func_result;
        }

      /* If this is a directory, walk its siblings.  */
      if ( flag == FTWALK_D ) // && !is_link )
        {
          int subwalk_result;

          errno = e;
          if ((subwalk_result = __walk_dir(path, func, level - 1)) != 0)
            {
              closedir(dp);
              return subwalk_result;
            }
        }

      /* Erase D_NAME[] from PATH.  */
      path[pathlen] = '\0';
    }

  closedir(dp);
  if (errno == 0)   /* normal case: this subtree exhausted */
    {
      errno = e;/* restore errno from previous syscall */
      return 0;
    }
  else
    return -1;      /* with whatever errno was set by readdir() */
}

int
ftwalk(const char *dir, int (*func)(const char *, struct stat *, int), int level )
{
  char pathbuf[FILENAME_MAX];
  int len;

  if (dir == NULL || func == NULL) { errno = EFAULT; return -1; }
  if (dir[0] == 0) { errno = ENOENT; return -1; }

  strcpy(pathbuf, dir);
  len = strlen(pathbuf);
  if (pathbuf[len-1] == ':') { pathbuf[len++] = '.'; pathbuf[len] = '\0'; }

  /* Fail for non-directories.  */
  struct stat st;
  if (stat( pathbuf, &st )) return -1;
  if (!S_ISDIR(st.st_mode)) { errno = ENOTDIR; return -1; }

  int func_result;

  if ((func_result = (*func)(pathbuf, &st, FTWALK_D)) != 0) return func_result;

  return __walk_dir( pathbuf, func, level );
}


////////////////////////////////////////////////////////////////////////////
//
// History functions
//

#define MAXHIST         10      // max history items per id
#define HISTIDPAD       8

void HistAdd( int hist_id, const char* str )
{
  String hstr = hist_id;
  StrPad( hstr, HISTIDPAD );
  hstr += ",";
  hstr += str;
  int z;
  z = HistIndex( hist_id, str );
  if ( z != -1 ) HistRemove( hist_id, z );
  z = HistCount( hist_id );
  while (z >= MAXHIST)
    {
    z--;
    HistRemove( hist_id, z );
    }
  if (z) z++;
  History.ins( 0, hstr );
};

const char* HistGet( int hist_id, int index )
{
  String hstr = hist_id;
  StrPad( hstr, HISTIDPAD );
  hstr += ",";
  int i = 0;
  int z;
  for ( z = 0; z < History.count(); z++ )
    if ( strncmp( hstr, History[z], HISTIDPAD+1 ) == 0 )
      {
      if ( index == -1 || index == i )
        return History[z] + HISTIDPAD+1;
      i++;
      }
  return NULL;
};

char* HistGet( int hist_id, int index, char* str )
{
  str[0] = 0;
  const char* pstr = HistGet( hist_id, index );
  if ( pstr )
    strcpy( str, pstr );
  return str;
};

int HistIndex( int hist_id, const char* value )
{
  int z;
  int cnt = HistCount( hist_id );
  for ( z = 0; z < cnt; z++ )
    if ( strcmp( value, HistGet( hist_id, z ) ) == 0 )
      return z;
  return -1;
};

int HistCount( int hist_id )
{
  String hstr = hist_id;
  StrPad( hstr, HISTIDPAD );
  hstr += ",";
  int cnt = 0;
  int z;
  for ( z = 0; z < History.count(); z++ )
    cnt += ( strncmp( hstr, History[z], HISTIDPAD+1 ) == 0 );
  return cnt;
};

// use hist_id=-1 and/or index=-1 to remove all
void HistRemove( int hist_id, int index )
{
  String hstr = hist_id;
  StrPad( hstr, HISTIDPAD );
  hstr += ",";
  int i = 0;
  int z = 0;
  while( z < History.count() )
    {
    if ( hist_id != -1 && strncmp( hstr, History[z], HISTIDPAD+1 ) != 0 ) { z++; continue; }
    if ( index != -1 && index != i ) { z++; i++; continue; }
    History.free( z );
    if ( index != -1 ) break;
    };
};

int HistMenu( int x, int y, const char* title, int hist_id )
{
  mb.freeall();
  int z;
  int cnt = HistCount( hist_id );
  if (cnt < 1) return -1;
  for ( z = 0; z < cnt; z++ )
    {
    sprintf(sss, "%d %s", (z+1)%10, HistGet( hist_id, z ) );
    mb.add(sss);
    }
  return MenuBox( x, y, title );
};

////////////////////////////////////////////////////////////////////////////
//
//
//

int CurrGetStrHistId; // this is a hack -- I'll have to reconsider input line
                      // history handling... later.
void GetStrHistory( int key, String &s, int &pos )
{
  if ( !CurrGetStrHistId ) return;
  if ( key != KEY_NPAGE && key != KEY_PPAGE ) return;
  ConCHide();

  int z = HistMenu( 5, 5, "Line History", CurrGetStrHistId );

  ConCShow();
  if ( z == -1 ) return;
  s = mb[z] + 2;
  StrCutSpc( s );
  pos = StrLen( s );
}

int GetStr( char* target, int hist_id, int x, int y ) // vfuuti.cpp
{
  if ( x == -1 ) x = 1;
  if ( y == -1 ) y = MAXY;
  int len = MAXX-3-x;
  CurrGetStrHistId = hist_id;
  if ( strcmp( target, "" ) == 0 && HistGet( hist_id, 0 ) )
    strcpy( target, HistGet( hist_id, 0 ) );
  if(TextInput( x, y, "", len, len, target, GetStrHistory ))
    {
    HistAdd( hist_id, target );
    CurrGetStrHistId = 0;
    return 1;
    }
  else
    {
    CurrGetStrHistId = 0;
    return 0;
    }
};

////////////////////////////////////////////////////////////////////////////
//
//
//

