;;; tc-tbl.el --- T-Code-dependent data

;; Copyright (C) 1989--1997 Kaoru Maeda, Yasushi Saito and KITAJIMA Akira.

;; Author: Kaoru Maeda <maeda@src.ricoh.co.jp>
;;	Yasushi Saito <yasushi@is.s.u-tokyo.ac.jp>
;;      KITAJIMA Akira <kitajima@ics.es.osaka-u.ac.jp>

;; $Id: tc-tbl.el,v 2.0.8.0 2000/03/04 05:53:00 akira Exp $

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.

;;; Commentary:
;;
;; set following variables:
;;	tcode-input-method
;;	tcode-transparent-mode-indicator
;;	tcode-zenkaku-mode-indicator
;;	tcode-tcode-mode-indicator
;;	tcode-zenkaku-tcode-mode-indicator
;;	tcode-hiragana-mode-indicator
;;	tcode-katakana-mode-indicator
;;	tcode-tbl
;;	tcode-non-2-stroke-char-list
;;	tcode-another-table
;;	tcode-special-commands-alist
;;	tcode-mode-help-string
;;	tcode-stroke-file-name

;;; Code:

(setq tcode-input-method 'tcode)

(setq tcode-transparent-mode-indicator "--"
      tcode-zenkaku-mode-indicator ""
      tcode-tcode-mode-indicator "TC"
      tcode-zenkaku-tcode-mode-indicator ""
      tcode-hiragana-mode-indicator ""
      tcode-katakana-mode-indicator "")

(setq tcode-tbl [
"õݤ񢣢Ͳᢣڿ"
"ȾյױӢ"
"ü˴Ƶѵ̷ʽ褼Ϲ"
"ɸز۶찵øǹˮ񻨴ۢ㴳ɧ"
"˿΢̩벡¬컶"
"ܶ찡ؾ˼â"
"ü͹Ƚæº︻ע"
"Ѿξ޽˽ľεʻ"
"̰һǵǡĢð"
"ɼʰζάθ§¸ܵᢣ˳颣"
"򰥲˷Ļú̹̳糫̵Ū"
"Ȳܰٵ쳵ͳ७ɴڲʬ饢΢ﺹեפХ"
"򹶾Ʈͼξ! Хݰƶʾ7 ( Ȥ콾⹩ȬƸ"
"°ϳӷӰ®ǽȯΩ¦ФŬ汧̾"
"Űô͵ߺٸڤʶ½򤰴夯8 ǯ򿭥"
"ħɾˡϺǤ˭μΨû"
"ϸʣ·ǵ޸ѿݽ²۹ι˱󥩾"
"ݻɮΤὨչīΥ¸ϫ򥻱ëƳǧǰƯ"
"Ǽƨ㸺񥣵մǶХ㻦鲿̼Ǹ"
"ٺᢣι̵вͥʸؼ¨"
"ѰֲɩĻž楹⤪ﲬʿ3 ȡƤҹ̹͸ÿͻ"
"԰ٳݷɳŵͺվޤԼʡ줬ڵ¢¤"
"ױشʩػ³4 ) ڳͻ5 1 ȾޥĻ"
"ڱŸʰɸʼФ6 طͽڰӡ0 2 "
"ݰߴ;ٸŻ׽ѹʹܤ⥷ѥܲüǤϤˤʤžȵȻĹ"
"ٹƢ꼢½ϩۤʪɬְ߿ƣͭʼ۶ʿ"
"Ἧźĥ͢ήϢŴϥӱʿɻ䥴迮"
"˻ﾷŰ̦Źụ́Ǹ¾̿¼"
"̴袣ƶ̱̱­۴Ѹŷʸĵһδ"
"ٷ뢣Ʒƫֶʴжʱҳ۽¼ǽĤᳰƥ"
"ϼŹĮ۷ͧ´鴷ԥɱ߾ڴ% ƻ"
"˷Ȩˬͻܰ˵ᵻ̥ƱȽͥᥦ"
"˼Ӽ°λǮϻưƬ۹꡽ѵȤԹ"
"Υ붲Ķ־˻ľҿ9 Ҹ⽵ɰѲܻ"
"ϳ˱²̤༷̳˾Ĳپʱʡ赤䲼Գ"
"нϯģץİŲϿ۾ûٶɽ޵󸱥ȥ俴պ"
"ǾϷƴãǶ˺Ƥ˴ĿԻ¿ϸǷܳȺƥ͡"
"αƦǢ񼺻ʷ޲ڵ亸ֱֲɥĴݷ߽ʧ˾ķ׿"
"ؾ? 彤±ŸٷïŽͷͤҤͿ"
"ԹȢ𢣢ȴؿôΦȻƲʥ̱ļñȥԾȿ"
])

(setq tcode-non-2-stroke-char-list
      (mapcar (function
	       (lambda (str)
		 (tcode-string-to-char str)))
	      '("" "" "")))

(setq tcode-another-table nil)

(setq tcode-special-commands-alist
      (nconc '(((0 0) . (lambda () (tcode-show-tables nil nil)))
					; 11 : LLɽɽ
	       ((0 9) . (lambda () (tcode-show-tables nil t)))
					; 10 : LRɽɽ
	       ((9 0) . (lambda () (tcode-show-tables t nil)))
					; 01 : RLɽɽ
	       ((9 9) . (lambda () (tcode-show-tables t t)))
					; 00 : RRɽɽ
	       ((1 1) . tcode-start-jiscode)
					; 22 : JIS ɽ
	       ((2 2) . (lambda ()
			  (setq tcode-alnum-2-byte-p
				(not tcode-alnum-2-byte-p))
			  (tcode-mode-line-redisplay)))
					; 33 : 1-2Хڤ괹
	       ((2 1) . tcode-switch-variable)
					; 32 : Υȥ
	       ((8 9) . (lambda ()
			  (setq tcode-zenkaku-mode (not tcode-zenkaku-mode))
			  (tcode-mode-line-redisplay)))
					; 90 : ѥ⡼
	       ((3 3) . (lambda ()
			  (tcode-display-stroke-for-char tcode-help-char)))
					; 44 : إ
	       ((4 4) . (lambda () (tcode-query-stroke (point))))
					; 55 : إ
	       ((6 6) . tcode-bushu-another-henkan)
					; 77 : postfix Ѵ
	       ((7 7) . (lambda () (tcode-transpose-strokes nil)))
					; 88 : transpose-strokes
	       ((8 8) . (lambda () (tcode-clear t)))
					; 99 : ѴΥ󥻥
	       ((26 23) . tcode-bushu-henkan)	; jf : Ѵγ
	       ((25 23) . tcode-kuten)
	       ((26 22) . tcode-touten))
	     (if tcode-use-egg-in-mazegaki
		 '(((23 26) . (lambda ()
				(setq egg:*mode-on* t
				      egg:*input-mode* nil)
				(setq tcode-in-mazegaki-p t)
				(toggle-egg-mode))))
					; fj: ޤѤѴ
	       '(((23 26) . tcode-mazegaki-start)
					; fj: 򤼽Ѵ
		 ((9 8) . tcode-mazegaki-alternative-start)
					; ֤֡դθ򤼽Ѵ
		 ;; 18פɤ߰ʸθַ򤼽Ѵ
		 ((0 7) . (lambda ()
			    (tcode-mazegaki-henkan 1 current-prefix-arg)))
		 ;; 28פɤʸθַ򤼽Ѵ
		 ((1 7) . (lambda ()
			    (tcode-mazegaki-henkan 2 current-prefix-arg)))

		 ;; 38פɤ߻ʸθַ򤼽Ѵ
		 ((2 7) . (lambda ()
			    (tcode-mazegaki-henkan 3 current-prefix-arg)))

		 ;; 48פɤ߻ʸθַ򤼽Ѵ
		 ((3 7) . (lambda ()
			    (tcode-mazegaki-henkan 4 current-prefix-arg)))

		 ;; 58פǳѤоݤȤַ򤼽Ѵ
		 ((4 7) . (lambda () (tcode-mazegaki-henkan nil t)))

		 ;; 29פɤʸγѤоݤȤ
		 ;; ַ򤼽Ѵ
		 ((1 8) . (lambda () (tcode-mazegaki-henkan 2 t)))

		 ;; 39פɤ߻ʸγѤоݤȤ
		 ;; ַ򤼽Ѵ
		 ((2 8) . (lambda () (tcode-mazegaki-henkan 3 t)))

		 ;; 49פɤ߻ʸγѤоݤȤ
		 ;; ַ򤼽Ѵ
		 ((3 8) . (lambda () (tcode-mazegaki-henkan 4 t)))

		 ;; 59פɤ߸ʸγѤоݤȤ
		 ;; ַ򤼽Ѵ
		 ((4 8) . (lambda () (tcode-mazegaki-henkan 5 t)))))))

(setq tcode-mode-help-string "\
T-Code⡼ΥϼΤȤꡣ
   jf : Ѵ⡼ɤ롣jfǤ³ȺƵŪѴ
	ԤȤǤ(see variable `tcode-use-postfix-bushu-as-default')
   fj : 򤼽ѴԤ(see variable `tcode-use-prefix-mazegaki')
   00, 01, 10, 11 : T-Codeɽɽ(01)
   22 : JIS ɰɽˤϡ
   32 : , . ڤؤ롣(see variable `tcode-switch-table-list')
   33 : T-Codeɽˤ뵭Ⱦڤؤ
   44 : ľϤʸǤɽ롣
   55 : ݥȰ֤ˤʸǤɽ롣
   77 : ݥˤʸѴԤ
   88 : ݥȰ֤ˤʸեȥ(: ̣->)
        ǤϥݥȤľʸѴ롣
   90 : ϥ⡼ɡT-Code⡼ɤȴޤͭ
   99 : 򤼽Ѵ⡼ɤѴ⡼ɤˤˡ
	󥻥뤹롣ޤإפä
   \\[toggle-input-method] : T-Code⡼ɤȴ롣

1ȥΥޥɤϰʲΤȤꡣ
\\{tcode-mode-map}
Ƶư줿ˤϡ`tcode-ready-hook' ¹Ԥ롣
ޤư٤`tcode-toggle-hook'¹Ԥ롣")

(setq tcode-stroke-file-name (concat tcode-data-directory "tcode.st"))

;;; tc-tbl.el ends here
