/* # skkinput (Simple Kana-Kanji Input)
 * table.h --- define roma-kana table, roma-kana rule list and prefix rule.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef TABLE_H
#define TABLE_H

struct roma_kana_table {
  char *prefix ;
  char *kana ;
  char *katakana ;
} ;

/* ޻ʤѴơ֥֣ */
static struct roma_kana_table skk_roma_kana_a[] = {
  { "",   "",   ""   },
  { "b" , "",   ""   },  { "by", "Ӥ", "ӥ" },
  { "ch", "", "" },  { "cy", "", "" }, 
  { "d",  "",   ""   },  { "dh", "Ǥ", "ǥ" },
  { "dy", "¤", "¥" },
  { "f",  "դ", "ե" },  { "fy", "դ", "ե" },
  { "g",  "",   ""   },  { "gy", "", "" },
  { "h",  "",   ""   },  { "hy", "Ҥ", "ҥ" },
  { "j",  "", "" },  { "jy", "", "" },
  { "k",  "",   ""   },  { "ky", "", "" },
  { "m",  "",   ""   },  { "my", "ߤ", "ߥ" },
  { "n",  "",   ""   },  { "ny", "ˤ", "˥" },
  { "p",  "",   ""   },  { "py", "Ԥ", "ԥ" },
  { "r",  "",   ""   },  { "ry", "", "" },
  { "s",  "",   ""   },  { "sh", "", "" },
  { "sy", "", "" }, 
  { "t",  "",   ""   },  { "th", "Ƥ", "ƥ" },
  { "ty", "", "" },
  { "v",  "", "" },{ "w",  "",   "" },
  { "x",  "",   ""   },  { "xk", "",   "" },
  { "xw", "",   ""   },  { "xy", "",   "" },
  { "y",  "",   ""   },
  { "z",  "",   ""   },  { "zy", "", "" },
  { NULL, NULL,     NULL }
} ;

/* ޻ʤѴơ֥֣ */
static struct roma_kana_table skk_roma_kana_i[] = {
  { "",   "",     ""   },
  { "b",  "",     ""   }, {"by", "Ӥ", "ӥ"},
  { "ch", "",     ""   }, {"cy", "", ""},
  { "d",  "",     ""   }, {"dh", "Ǥ", "ǥ"},
  { "dy", "¤",   "¥" },
  { "f",  "դ",   "ե" }, {"fy", "դ", "ե"},
  { "g",  "",     ""   }, {"gy", "", ""},
  { "h",  "",     ""   }, {"hy", "Ҥ", "ҥ"},
  { "j",  "",     ""   }, {"jy", "", ""},
  { "k",  "",     ""   }, {"ky", "", ""},
  { "m",  "",     ""   }, {"my", "ߤ", "ߥ"},
  { "n",  "",     ""   }, {"ny", "ˤ", "˥"},
  { "p",  "",     ""   }, {"py", "Ԥ", "ԥ"},
  { "r",  "",     ""   }, {"ry", "ꤣ", "ꥣ"},
  { "s",  "",     ""   }, {"sh", "",   ""},
  { "sy", "",   "" },
  { "t",  "",     ""   }, {"th", "Ƥ", "ƥ"},
  { "ty", "",   "" },
  { "v",  "", "" }, {"w",  "", ""},
  { "x",  "",     ""   }, {"xw", "",   ""},
  { "z",  "",     ""   }, {"zy", "", ""},
  { NULL, NULL,     NULL   }
} ;

/* ޻ʤѴơ֥֣ */
static struct roma_kana_table skk_roma_kana_u[] = {
  { "",   "",   ""   },
  { "b",  "",   ""   }, { "by", "Ӥ", "ӥ" },
  { "ch", "", "" }, { "cy", "", "" },
  { "d",  "",   ""   }, { "dh", "Ǥ", "ǥ" },
  { "dy", "¤", "¥" },
  { "f",  "",   ""   }, { "fy", "դ", "ե" },
  { "g",  "",   ""   }, { "gy", "", "" },
  { "h",  "",   ""   }, { "hy", "Ҥ", "ҥ" },
  { "j",  "", "" }, { "jy", "", "" },
  { "k",  "",   ""   }, { "ky", "", "" },
  { "m",  "",   ""   }, { "my", "ߤ", "ߥ" },
  { "n",  "",   ""   }, { "ny", "ˤ", "˥" },
  { "p",  "",   ""   }, { "py", "Ԥ", "ԥ" },
  { "r",  "",   ""   }, { "ry", "", "" },
  { "s",  "",   ""   }, { "sh", "", "" },
  { "sy", "", "" },
  { "t",  "",   ""   }, { "th", "Ƥ", "ƥ" },
  { "ts", "",   ""   }, { "ty", "", "" },
  { "v",  "", ""   }, { "w",  "",   ""   },
  { "x",  "",   ""   }, { "xt", "",   ""   },
  { "xts","",   ""   }, { "xy", "",   ""   },
  { "y",  "",   ""   },
  { "z",  "",   ""   }, { "zy", "", "" },
  { NULL, NULL,     NULL }
} ;

/* ޻ʤѴơ֥֣ */
static struct roma_kana_table skk_roma_kana_e[] = {
  { "",   "",     ""   },
  { "b",  "",     ""   }, { "by", "Ӥ", "ӥ" },
  { "ch", "",   "" }, { "cy", "", "" },
  { "d",  "",     ""   }, { "dh", "Ǥ", "ǥ" },
  { "dy", "¤",   "¥" },
  { "f",  "դ",   "ե" }, { "fy", "դ", "ե" },
  { "g",  "",     ""   }, { "gy", "", "" },
  { "h",  "",     ""   }, { "hy", "Ҥ", "ҥ" },
  { "j",  "",   "" }, { "jy", "", "" },
  { "k",  "",     ""   }, { "ky", "", "" },
  { "m",  "",     ""   }, { "my", "ߤ", "ߥ" },
  { "n",  "",     ""   }, { "ny", "ˤ", "˥" },
  { "p",  "",     ""   }, { "py", "Ԥ", "ԥ" },
  { "r",  "",     ""   }, { "ry", "ꤧ", "ꥧ" },
  { "s",  "",     ""   }, { "sh", "", "" },
  { "sy", "",   "" },
  { "t",  "",     ""   }, { "th", "Ƥ", "ƥ" },
  { "ty", "",   "" },
  { "v",  "", "" }, { "w",  "", "" },
  { "x",  "",     ""   }, { "xk", "",   ""   },
  { "xw", "",     ""   },
  { "y",  "",   "" },
  { "z",  "",     ""   }, { "zy", "", "" },
  { NULL, NULL,     NULL   }
} ;

/* ޻ʤѴơ֥֣ */
static struct roma_kana_table skk_roma_kana_o[] = {
  { "",   "",     ""   },
  { "b",  "",     ""   }, { "by", "Ӥ", "ӥ" },
  { "ch", "",   "" }, { "cy", "", "" },
  { "d",  "",     ""   }, { "dh", "Ǥ", "ǥ" },
  { "dy", "¤",   "¥" },
  { "f",  "դ",   "ե" }, { "fy", "դ", "ե" },
  { "g",  "",     ""   }, { "gy", "", "" },
  { "h",  "",     ""   }, { "hy", "Ҥ", "ҥ" },
  { "j",  "",   "" }, { "jy", "", "" },
  { "k",  "",     ""   }, { "ky", "", "" },
  { "m",  "",     ""   }, { "my", "ߤ", "ߥ" },
  { "n",  "",     ""   }, { "ny", "ˤ", "˥" },
  { "p",  "",     ""   }, { "py", "Ԥ", "ԥ" },
  { "r",  "",     ""   }, { "ry", "", "" },
  { "s",  "",     ""   }, { "sh", "", "" },
  { "sy", "",   "" },
  { "t",  "",     ""   }, { "th", "Ƥ", "ƥ" },
  { "ty", "",   "" },
  { "v",  "", "" }, { "w",  "",   ""   },
  { "x",  "",     ""   }, { "xy", "",   ""   },
  { "y",  "",     ""   },
  { "z",  "",     ""   }, { "zy", "", "" },
  { NULL, NULL,     NULL   }
} ;

/* ʸλ°ơ֥롣*/
static int skk_char_type_vector[] = {
  0, 0, 0, 0, 0, 0, 0, 0,
  5, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 0, 4, 4, 4,
  4, 0, 4, 4, 4, 4, 4, 4,
  0, 4, 4, 0, 0, 0, 0, 0,
  0, 3, 1, 1, 1, 3, 1, 1,
  1, 3, 1, 1, 0, 1, 2, 3,
  1, 0, 1, 1, 1, 3, 1, 1,
  2, 1, 1, 0, 0, 0, 0, 5,
} ;

/* ǽ prefix Υꥹ */
static char *skk_prefix_list[] = {
  "by", "ch", "cy", "dh", "dy", "fy", "gy", "hy", "jy", "ky",  "my",
  "py", "ry", "sh", "sy", "th", "ts", "ty", "xk", "xt", "xts", "xw",
  "xy", "zy", "ny", NULL
} ;

#if 0
static struct skk_rom_kana_rule skkinput_rom_kana_rule_list[] = {
  { "nn", "n",  "", "" },
  { "n'", NULL, "", "" },
  { "nL", NULL, "", "" },
  { "nl", NULL, "", "" },
  { NULL, NULL, NULL, NULL },
} ;
#endif
#endif

