/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

GtkText *TweakInfoTextPtr;

void toggle_tweak (GtkWidget *widget, Tweaks_t *tweaks)
{
	if (tweaks->current_value==0)
		tweaks->current_value=1;
	else
		tweaks->current_value=0;
}

void display_tweak_info (GtkWidget *widget, Tweaks_t *tweaks)
{
	static char enable_best[]="Enabled is best.";
	static char disable_best[]="Disabled is best.";
	static char unknown_best[]="Unknown which setting is best, please report your findings.";

	char description[512];
	char *descriptionptr;

	//FIXME: Allow for inbuilt AND a normal description.
	switch (tweaks->description[0]) {

		case '0':
			strncpy (description, disable_best, strlen(disable_best));
			descriptionptr = description;
			description[strlen(disable_best)]='\0';
			break;

		case '1':
			strncpy (description, enable_best, strlen(enable_best));
			descriptionptr = description;
			description[strlen(enable_best)]='\0';
			break;
	
		case '?':
			strncpy (description, unknown_best, strlen(unknown_best));
			descriptionptr = description;
			description[strlen(unknown_best)]='\0';
			break;
	
		default:	
			descriptionptr = tweaks->description;
			break;
	}

	gtk_text_freeze ((TweakInfoTextPtr));
	gtk_text_set_point ((TweakInfoTextPtr), 0);
	gtk_text_forward_delete (TweakInfoTextPtr,
					gtk_text_get_length((TweakInfoTextPtr)));
	gtk_text_insert ((TweakInfoTextPtr), NULL, NULL, NULL, descriptionptr, strlen(descriptionptr));
	gtk_text_thaw((TweakInfoTextPtr));
}


GtkWidget *CreateButton(GtkWidget *table, Tweaks_t *tweaks, struct pci_dev *current_dev, int column)
{
	GtkWidget *button;

	button = gtk_check_button_new_with_label (tweaks->name);

	if ((pci_read_byte (current_dev, tweaks->reg) & tweaks->mask) == tweaks->value)
		tweaks->original_value=TRUE;
	else
		tweaks->original_value=FALSE;
	tweaks->current_value = tweaks->original_value;

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), tweaks->current_value);

	gtk_table_attach(GTK_TABLE(table), button, 0, 1, column, column+1,
					GTK_FILL|GTK_EXPAND, 0, 5, 5);
	gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (toggle_tweak), tweaks);
	gtk_signal_connect (GTK_OBJECT (button), "enter", GTK_SIGNAL_FUNC (display_tweak_info), tweaks);

	gtk_widget_show(button);
	return (button);
}
