/* LOCKVC Version 3.4 (c) 1994, 1995, 1997 by Matthias Straub */
/* shadow-password option added by Ed Beaumont */
/* PAM option added by Lawson Whitney */
/* integer math derived from a patch by Jeff Epler */
/* this file was released under GPL */
/* see COPYING for details */
		

#define CONFIG "/etc/maxlock"  /* change if you don't like the filename */
#define UMODE 0                /* key-mode    */
#define SMODE 1                /* passwd-mode */
#define gets(b) (begets(b, sizeof(b)))
#ifdef USE_PAM
#include <security/pam_appl.h>
#endif /* USE_PAM */ 
#ifdef SHADOW_PASSWD
#include <shadow.h>
#endif
#include <sys/stat.h>
#include <string.h>
#include <pwd.h>
#include <signal.h>
#include <unistd.h> 
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <math.h>
#include <termio.h>
#include <vga.h>

int secure;
int pal[256*3];
char buff[100];
char key[100];
char rkey[100];
char uName[100];
char rName[100];
struct termios console;
#ifdef SHADOW_PASSWD
struct spwd *sword;
struct spwd *rpword;
struct passwd *rpwork;
char name[32];
#else
struct passwd *rpword;
#endif
struct passwd *pword;
int keymode;
char * begets(char * b, int n)
{	int el;
	fgets(b, n, stdin);
	el = strlen(b);
	if (el)
	{	if (b[el-1] == 10) b[el-1] = 0;
	}
	return b; 
}	
#ifdef USE_PAM
static char *PAM_password;
static char *PAM_name;
static int PAM_conv (int num_msg,
		     const struct pam_message **msg,
		     struct pam_response **resp,
		     void *appdata_ptr) {
	int replies = 0;
	struct pam_response *reply = NULL;

	reply = malloc(sizeof(struct pam_response)*num_msg);
	if (!reply) return PAM_CONV_ERR;
	#define COPY_STRING(s) (s) ? strdup(s) : NULL

	for (replies = 0; replies < num_msg; replies++) {
		switch (msg[replies]->msg_style) {
		case PAM_PROMPT_ECHO_OFF:
			/* wants password */
			reply[replies].resp_retcode = PAM_SUCCESS;
			reply[replies].resp = COPY_STRING(PAM_password);
			break;
		case PAM_TEXT_INFO:
			/* ignore the informational mesage */
			/* but first clear out any drek left by malloc */
			reply[replies].resp = NULL;
			break;
		case PAM_PROMPT_ECHO_ON:
			/* user name given to PAM already */
			/* fall through */
		default:
			/* unknown or PAM_ERROR_MSG */
			free (reply);
			return PAM_CONV_ERR;
		}
	}
	*resp = reply;
	return PAM_SUCCESS;
}

static struct pam_conv PAM_conversation = {
	&PAM_conv,
	NULL
};
#endif

void isconsole() /* vgalib1.2 */
     {
	struct stat chkbuf;
	int major, minor;
	int fd;
	
	fd = dup(2);
	fstat(fd, &chkbuf);
	major = chkbuf.st_rdev >> 8;
	minor = chkbuf.st_rdev & 0xff;
	
	if (major != 4 || minor >= 64)
	  {
	     printf("Not running in graphics-capable virtual console.\n");
	     exit(-1);
	  }
	close(fd);            
     }
             
void kickout() 
     {
	setuid(getuid());
	kill(-1,SIGTERM);
	sleep(2);
	kill(-1,SIGKILL);
	exit(0);
     }

void res_term()
     {
	tcsetattr(STDIN_FILENO, TCSANOW, &console);
     }

void invis_term()
     {
	struct termios terminal;
	tcgetattr(STDIN_FILENO, &console);
	terminal=console;
	terminal.c_lflag &= !(ECHO | ECHOCTL);
	terminal.c_lflag |= ICANON;
	terminal.c_oflag |= OPOST;
	tcsetattr(STDIN_FILENO, TCSANOW, &terminal);
     }


void get_pal()
{
vga_getpalvec(0,256,pal);
}
void res_pal()
{
vga_setpalvec(0,256,pal);
}
	
void authenticate()
	  {
	  int mode;
#ifdef USE_PAM
          int pam_error;
	  int repid;
#endif
	     while (vga_getkey() != 0) {}
	     get_pal();
	     mode=vga_getcurrentmode(); 
	     vga_setmode(TEXT);
	     invis_term();

	     if(keymode==UMODE)
	       {
		  printf("\nEnter key to unlock: ");
		  gets(buff);
		  printf("\n");
		  if(strcmp(buff,key)==0)
		    {
		       memset(buff,0,strlen(buff));
		       memset(key,0,strlen(key));
		       exit(0);
		    }
	       }
	     else 
	       {
		  printf("\n%s's password: ",uName);
		  gets(buff);
		  printf("\n");
#ifdef USE_PAM
		  PAM_password = buff;
		  PAM_name = uName;
		  seteuid(0);     /* for root passwd check */
    for (repid = 0; repid <2; repid++) 
      {
	pam_handle_t *pamh = NULL;
	pam_error = pam_start("lockvc", PAM_name, &PAM_conversation, &pamh);
	if (pam_error == PAM_SUCCESS)
	  {
		pam_error = pam_authenticate(pamh, 0);
		pam_end(pamh, PAM_SUCCESS);
		if (pam_error == PAM_SUCCESS) 
		  {
		     memset(buff,0,strlen(buff));
		     exit(0);	  
	  	  }
	  }	  

	PAM_name = rName;
      }
	seteuid(getuid());
#else /* USE_PAM */
		  		  
		  /* 13 chars should be save enough -> */
		  if((strncmp(key,crypt(buff,key),13)==0)||strncmp(rkey,crypt(buff,rkey),13)==0)
		    {
		       memset(buff,0,strlen(buff));
		       exit(0);
		    }
#endif  /* USE_PAM */
	       }
	     res_term();
	     vga_setmode(mode);
	     res_pal(); 
	  }
signals()
{
#ifndef TEST
    if (secure) {
	signal(SIGINT,SIG_IGN);
	signal(SIGHUP,SIG_IGN);
	signal(SIGTERM,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	signal(SIGABRT,SIG_IGN);
    }
#endif        /*test */
}
void vga_it()
{
	int savuid = getuid();
	setreuid(0,0);
	vga_init();
	setreuid(savuid,0);
	seteuid(getuid());
	return;
}	
void main(int argc,char **argv)
     {
	int j;
	int saver;
	FILE *config;
	int maxtime;
#ifdef DEBUG
	setreuid(501, 0);
#endif	
	secure = 1;
	if (argv[0] [strlen(argv[0]) -1] == 116) secure = 0;
	printf("\n---          Virtual-Console-Locker by M.Straub '97 V3.4           ---\n");
        
	mod_choose(argc,argv,&saver);
	
	if(((config=fopen(CONFIG,"r"))!=NULL) && (getuid()!=0))
	  {
	     fscanf(config,"%i",&maxtime);
	printf(  "---          locking-time is limited to %i minutes.		   ---\n",maxtime);
	     maxtime*=60;
	     alarm(maxtime);
	     signal(SIGALRM,kickout);
	     fclose(config);
	  }
#ifdef DEBUG
	if(((pword=getpwuid(501))!=NULL) && (strlen(pword->pw_passwd)>0))
#else
	if(((pword=getpwuid(getuid()))!=NULL) && (strlen(pword->pw_passwd)>0))
#endif	
	  {
#ifdef OLD_VGALIB
	     setuid(0);   /* preempt setuid(getuid()); in old vga_init */
#endif /* OLD_VGALIB */
#ifdef SHADOW_PASSWD
	     
	     if(seteuid(0) != 0)
	       {
		  if(errno == EPERM)
		    printf("Program not SUIDed - shadow passwords wont work!\n");
		  else
		    printf("ERROR: Type %i returned from seteuid()\n",errno);
		  vga_it();
		  isconsole();
		  do
		    {
		       printf("\nKey: ");
		       gets(key);
		       printf("\nAgain: ");
		       gets(buff);
		    } while(strcmp(key,buff)!=0);
		  keymode=UMODE;
	       }
	     else	
	       {
		  name[0]='\0';
		  strncpy(name,pword->pw_name, sizeof(char[32]));	
		  if((sword=getspnam(name))==NULL)
		    printf("getspnam() failed!\n");
		  strcpy(uName,sword->sp_namp);
#ifndef USE_PAM
		  strcpy(key,sword->sp_pwdp);
#endif  /* !USE_PAM */
		  rpwork=getpwuid(0);
		  strcpy(rName,rpwork->pw_name);
#ifndef USE_PAM
		  rpword=getspnam(rName);
		  strcpy(rkey,rpword->sp_pwdp);
#endif  /* !USE_PAM */
		  keymode=SMODE;
		  vga_it();
		  isconsole();
	       }
#else /* SHADOW_PASSWD */
	     strcpy(uName,pword->pw_name);
#ifndef USE_PAM
	     strcpy(key,pword->pw_passwd);	     
#endif   /* USE_PAM */
	     rpword=getpwuid(0);
#ifndef USE_PAM
	     strcpy(rkey,rpword->pw_passwd);
#endif /* USE_PAM */
	     strcpy(rName,rpword->pw_name);
	     keymode=SMODE;
	     vga_it();
	     isconsole();
#endif  /* SHADOW_PASSWD */
	  }
	else
	  {
	     vga_it();
	     isconsole();
	     do
	       {
		  printf("\nKey: ");
		  gets(key);
		  printf("\nAgain: ");
		  gets(buff);
	       } while(strcmp(key,buff)!=0);
	     keymode=UMODE;
	  }
	vga_lockvc();
	signals();	
	mod_start(argc, argv, &saver);
     }
