/*----------------------------------------------------------------------------*

	LinuxInfo_intel.c
		by Alex Buell
			September 1998

 ----------------------------------------------------------------------------- 

	Handles the Intel architecture	

 ----------------------------------------------------------------------------- 

	HISTORY

	1.0.1 - Initial development
	1.0.5 - Added MHz (2.1.127+)
	1.0.6 - Completely rewrote code! =)
	1.0.9 - Patched for Cyrix 586 
	1.1.0 - Patched for Mobile Pentiums
	1.1.1 - Patched for Covington version of Celerons & AMD K6-3 series. 
	1.1.2 - Patched for AMD 5x86

 -----------------------------------------------------------------------------*/

#include "linuxinfo.h"

#ifdef system_intel

void GetHardwareInfo(struct hw_stat *hw)
{
	int processors = 0; 
	float bogomips = 0.0;
	float tempbogo;
	float tempMHz = 0.0;
	LONGLONG memory = 0;

	char temp_string[BUFSIZ], temp_string2[BUFSIZ];
	char chip[BUFSIZ], vendor[BUFSIZ], model[BUFSIZ], Mhz[BUFSIZ];

	char *p;

	struct stat st_buf;

	while (!feof(cpuinfo_file)) 
	{
		fgets(temp_string, BUFSIZ, cpuinfo_file); /* read the whole of the line */

		if (splitstring(temp_string, temp_string2))
		{
			if (strncmp(temp_string, "processor", strlen("processor")) == 0)
				processors++;

			if (strncmp(temp_string, "vendor_id", strlen("vendor_id")) == 0)
			{
				if (strncmp(temp_string2, "GenuineIntel", strlen("GenuineIntel")) == 0)
					strcpy(vendor, "Intel");

				if (strncmp(temp_string2, "AuthenticAMD", strlen("AuthenticAMD")) == 0)
					strcpy(vendor, "AMD");

				if (strncmp(temp_string2, "CentaurHauls", strlen("CentaurHauls")) == 0)
					strcpy(vendor, "Centaur");

				if (strncmp(temp_string2, "CyrixInstead", strlen("CyrixInstead")) == 0)
					strcpy(vendor, "Cyrix");

			}

			/* this is the hard bit! =) */
			if (strncmp(temp_string, "model", strlen("model")) == 0) 
			{
				if (strncmp(temp_string2, "K6 (166 - 266)", strlen("K6 (166 - 266)")) == 0)
					strcpy(model, "K6");

				if (strncmp(temp_string2, "K6-2 (PR233 - PR333)", strlen("K6-2 (PR233 - PR333)")) == 0)
					strcpy(model, "K6-2");

				if (strncmp(temp_string2, "AMD-K6(tm) 3D", strlen("AMD-K6(tm) 3D")) == 0)
					strcpy(model, "K6-2 (3DNow)");
				
				if (strncmp(temp_string2, "AMD-K6(tm) 3D+", strlen("AMD-K6(tm) 3D+")) == 0)
					strcpy(model, "K6-3 (3DNow)");

				if (strncmp(temp_string2, "Am5x86", strlen("Am5x86")) == 0)
					strcpy(model, "5x86");

				if (strncmp(temp_string2, "C6", strlen("C6")) == 0)
					strcpy(model, "C6");
			
				if (strncmp(temp_string2, "6x86", strlen("6x86")) == 0)
					strcpy(model, "6x86");
	
				if (strncmp(temp_string2, "6x86MX", strlen("6x86MX")) == 0)
					strcpy(model, "6x86MX");

				if (strncmp(temp_string2, "Pentium 75+", strlen("Pentium 75+")) == 0)
					strcpy(model, "Pentium");
				
				if (strncmp(temp_string2, "Pentium MMX", strlen("Pentium MMX")) == 0)
					strcpy(model, "Pentium MMX");

				if (strncmp(temp_string2, "Mobile Pentium MMX", strlen("Mobile Pentium MMX")) == 0)
					strcpy(model, "Mobile Pentium MMX");

				if (strncmp(temp_string2, "Pentium Pro", strlen("Pentium Pro")) == 0)
					strcpy(model, "Pentium Pro");
				
				if (strncmp(temp_string2, "Pentium II (Klamath)", strlen("Pentium II (Klamath)")) == 0)
					strcpy(model, "Pentium II (Klamath)");
				
				if (strncmp(temp_string2, "Pentium II (Deschutes)", strlen("Pentium II (Deschutes)")) == 0)
					strcpy(model, "Pentium II (Deschutes)");
				
				if (strncmp(temp_string2, "Celeron (Mendocino)", strlen("Celeron (Mendocino)")) == 0)
					strcpy(model, "Celeron (Mendocino)");

				if (strncmp(temp_string2, "Celeron (Covington)", strlen("Celeron (Covington)")) == 0)
                                        strcpy(model, "Celeron (Covington)");

			}

			if (strncmp(temp_string, "cpu MHz", strlen("cpu MHz")) == 0)
				tempMHz = atol(temp_string2);

			if (strncmp(temp_string, "bogomips", strlen("bogomips")) == 0)
				bogomips = bogomips + atof(temp_string2);
		}

		
	}

	stat(MEMORY_FILE, &st_buf);
	memory = st_buf.st_size;
	memory /= 1024; memory /= 1024;
	sprintf(hw->hw_memory, "%ld", (long int)memory);

	hw->hw_processors = processors;

	sprintf(hw->hw_cpuinfo, "%s %s", vendor, model);
	sprintf(hw->hw_bogomips, "%0.2f", bogomips);
	if (tempMHz == 0.0)
		sprintf(hw->hw_megahertz, "Unknown");
	else
		sprintf(hw->hw_megahertz, "%d", (int)tempMHz);
}

#endif /* system_intel */
