/* defs.h - MemTest-86 assembler/compiler definitions */

/* Copyright 1999,  Chris Brady
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee
 * is granted provided that the above copyright notice appears in all copies.
 * It is provided "as is" without express or implied warranty.
 */ 

#define SETUPSECS	4		/* Number of setup sectors */

/*
 * Caution!! Do not change TESTADR, MAINSZ, TESTSZ or RELOBASE without also
 * editing the Makefile.
 */
#define TESTADR		0x1000		/* Final adrs for the test code */
#define MAINSZ		0x7800		/* Size of primary test code */
#define TSTSIZE		0xf400		/* Total test size, 2*MAINSZ+0x400 */
#define RELOBASE	0x100000	/* Relocation base address */

#define LOW_ADR		0x00 	        /* Lowest adrs for testing */
#define START_ADR	TSTSIZE+TESTADR /* Starting adrs for testing */
#define BOOTSEG		0x07c0		/* Segment adrs for inital boot */
#define INITSEG		0x9000		/* Segment adrs for relocated boot */
#define SETUPSEG	INITSEG+0x20	/* Segment adrs for relocated setup */
#define TESTSEG		TESTADR/0x10	/* Final segment adrs for test code */
#define TSTLOAD		0x1000		/* Segment adrs for load of test */
#define KERNEL_CS	0x10		/* 32 bit segment adrs for code */
#define KERNEL_DS	0x18		/* 32 bit segment adrs for data */
