/******************************************************************************\
 gnofin/imp-qif.h   $Revision: 1.2 $
 Copyright (C) 1999 Marty Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef FIN_IMP_QIF_H
#define FIN_IMP_QIF_H

#include "import.h"

extern FinImportFilter FinImport_QIF;

#define	TYPEBANK_TOK			54
#define	TYPECASH_TOK			55
#define	TYPECCARD_TOK			56
#define	TYPEINVST_TOK			57
#define	TYPEOTHA_TOK			58
#define	TYPEOTHL_TOK			59
#define	ACCOUNT_TOK			60
#define	TYPECAT_TOK			61
#define	TYPECLASS_TOK			62
#define TYPEMEMORIZED_TOK		63
#define	OPTIONALLXFR_TOK		64
#define	NONINVEST_DATE_TOK		65
#define	NONINVEST_AMOUNT_TOK		66
#define	NONINVEST_CLEARED_TOK		67
#define	NONINVEST_NUM_TOK		68
#define	NONINVEST_PAYEE_TOK		69
#define	NONINVEST_MEMO_TOK		70
#define	NONINVEST_ADDRESS_TOK		71
#define	NONINVEST_CATEGORY_TOK		72
#define	NONINVEST_CATEGORYINSPLIT_TOK	73
#define	NONINVEST_MEMOINSPLIT_TOK	74
#define	NONINVEST_DOLLARAMOUNT_TOK	75
#define	ENDOFENTRY_TOK			76
#define ACCOUNTMARKER_TOK		77
#define TYPEMARKER_TOK			78

typedef struct {
	char*	name;
	int	value;
	} KEYWORD;

static KEYWORD keywords[] = {
	{"!Type:Bank",			TYPEBANK_TOK},
	{"!Type:Cash",			TYPECASH_TOK},
	{"!Type:CCard",			TYPECCARD_TOK},
	{"!Type:Invst",			TYPEINVST_TOK},
	{"!Type:Oth A",			TYPEOTHA_TOK},
	{"!Type:Oth L",			TYPEOTHL_TOK},
	{"!Account",			ACCOUNT_TOK},
	{"!Type:Cat",			TYPECAT_TOK},
	{"!Type:Class",			TYPECLASS_TOK},
	{"!Type:Memorized",		TYPEMEMORIZED_TOK},
	{"!Option:AllXfr",		OPTIONALLXFR_TOK},
	{"D",				NONINVEST_DATE_TOK},
	{"T",				NONINVEST_AMOUNT_TOK},
	{"C",				NONINVEST_CLEARED_TOK},
	{"N",				NONINVEST_NUM_TOK},
	{"P",				NONINVEST_PAYEE_TOK},
	{"M",				NONINVEST_MEMO_TOK},
	{"A",				NONINVEST_ADDRESS_TOK},
	{"L",				NONINVEST_CATEGORY_TOK},
	{"S",				NONINVEST_CATEGORYINSPLIT_TOK},
	{"E",				NONINVEST_MEMOINSPLIT_TOK},
	{"$",				NONINVEST_DOLLARAMOUNT_TOK},
	{"^",				ENDOFENTRY_TOK},
	{"!Type",			TYPEMARKER_TOK},
	{"!Acco",			ACCOUNTMARKER_TOK}
	};

#define QIF_NUMOFKEYWORDS (sizeof (keywords) / sizeof (KEYWORD))
	
gboolean qif_import (void* vw, FILE * file, gchar* filename);

#endif
