### Copyright (C) 1995-1997 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

######################################################################
### This function format the text, which is given as argument to
### the Help, Desc, ShortDesc etc. functions
######################################################################
proc makeText {arg} {
  regsub -all "\n " [join $arg] "\n" arg
  return $arg
}

proc newfile file {
  global __currentFile
  set __currentFile $file
}

proc H {number args} {
  global __currentFile __language
  if {$__currentFile == "common"} {
    set __language($number) [makeText $args]
  } else {
    set __language($__currentFile,$number) [makeText $args]
  }
}

######################################################################
### If the environment variable LANG is defined, then use this language
### if possible.
### see /usr/X11R6/lib/X11/locale/locale.dir for a list of languages
######################################################################
proc loadLanguageInfo {} {
  global argv __system
  if {[file exists [lindex $argv 0]/text-$__system(language).tcl]} {
    source [lindex $argv 0]/text-$__system(language).tcl
  } else {
    puts "missing language information for language $__system(language)"
    exit -1
  }
}


###############################################################
### load a local command(s) from command-$__language.tcl
###############################################################
proc loadlocalCommand {} {
  global argv
  global __system
  if {[file exists [lindex $argv 0]/command-$__system(language).tcl]} {
    source [lindex $argv 0]/command-$__system(language).tcl
  }
}

###############################################################
### This function will expand a token in a text
###############################################################
proc langExp {token newText text} {
  set first [string first $token $text]
  set start [string range $text 0 [expr $first-1]]
  set last [string range $text [expr $first+[string length $token]] end]
  return $start$newText$last
}












proc getModuleList {} {
  global __mods __system libPath
  foreach lang $__system(languages) {
    foreach module [glob -nocomplain $libPath/$lang/*] {
      set name [lindex [split $module /] end]
      if {$name != ".." && $name != "." && $name != "CVS" && $name != "RCS"} {
        if {[file exists $module/version]} {
          set FILE [open $module/version]
          set version [gets $FILE]
          close $FILE
        } else {
          set version "??"
        }
        if {[info exists __mods($name)]} {
          lappend __mods($name) [list $lang $version]
        } else {
          set __mods($name) [list [list $lang $version]]
        }
      }
    }
  }
}

proc askForInfo {} {
  global __modName __system __mods
  toplevel .selectMod
  wm title .selectMod "The Dotfile Generator"

  getModuleList
  pack [label .selectMod.langtext -text "Language of the menus etc :"] -anchor w

  pack [frame .selectMod.lang] -anchor w
  pack [label .selectMod.lang.space -width 2] -side left
  pack [frame .selectMod.lang.labels]
  foreach lang $__system(languages) {
    radiobutton .selectMod.lang.labels.$lang -text $lang -variable __system(language) -value $lang
    pack .selectMod.lang.labels.$lang -anchor w 
    }

  pack [frame .selectMod.line1  -height 0.1c -relief sunken -bd 1] -fill x -expand 1 -pady 10 
  pack [label .selectMod.mod -text "Module to start:"] -anchor w
  set modules [lsort [array names __mods]]
  set __modName [lindex $modules 0]

  pack [frame .selectMod.mods] -anchor w
  pack [label .selectMod.mods.modspace -width 2] -side left
  pack [frame .selectMod.mods.labels]
  foreach m $modules {
    radiobutton .selectMod.mods.labels.$m -text $m -command "selectLanguage $m" \
      -value $m -variable __modName
    pack .selectMod.mods.labels.$m -anchor w 
  }

  pack [frame .selectMod.line2  -height 0.1c -relief sunken -bd 1] -fill x -expand 1 -pady 10

  pack [label .selectMod.modver -text "Module version:"] -anchor w
  pack [frame .selectMod.ver] -anchor w
  pack [label .selectMod.ver.verspace -width 2] -side left
  pack [frame .selectMod.ver.labels]

  pack [frame .selectMod.line3  -height 0.1c -relief sunken -bd 1] -fill x -expand 1 -pady 10

  pack [button .selectMod.but -text "OK" -command go]
  
  selectLanguage $__modName
  tkwait window .selectMod
}

proc selectLanguage {mod} {
  global __mods __modLang __system

  destroy .selectMod.ver.labels
  pack [frame .selectMod.ver.labels]
  set found 0
  set englishFound 0
  foreach inf $__mods($mod) {
    set lang [lindex $inf 0]
    set version [lindex $inf 1]
    if {$lang == $__system(language)} {
      set __modLang $__system(language)
      set found 1
    } elseif {$lang == "english"} {
      set englishFound 1
    }
    
    radiobutton .selectMod.ver.labels.$lang -text "$lang (version $version)" \
      -value $lang -variable __modLang
    pack .selectMod.ver.labels.$lang -anchor w
  }
  if {!$found} {
    if {$englishFound} {
      set __modLang english
    } else {
      set __modLang [lindex [lindex $__mods($mod) 0] 0]
    }
  }
}

proc go {} {
  destroy .selectMod
  
}

if {[info exists env(LANG)]} {
  if {[regexp "^ja.*" $env(LANG) ]} {
    set __system(language) japanese
  } elseif {[regexp "^en.*" $env(LANG)]} {
    set __system(language) english
  }
}

