/*****************************************************************************
 *  Backup Copy                                                              *
 *  Programmed by: Kevin Lindsay                                             *
 *  Copyright (c) 1998 NetNation Communications Inc                          *
 * ***************************************************************************/ 

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "config.h"
#include "statmalloc.h"


/* Load file into buffer */
char *
load_file(const char *filename)
{
   int res = 1;
   int fptr;
   struct stat *fbufstat;
   char *fbuf;
   
   fbufstat = (struct stat *) malloc(sizeof(struct stat));
   
   if ((fptr = open(filename,O_RDONLY)) != -1) {
      fstat(fptr,fbufstat);
      
      fbuf = (char *) malloc(fbufstat->st_size+1);
      
      read(fptr,fbuf,fbufstat->st_size);
      
      close(fptr);
      
   } else {
      res = 0;
      fbuf = (char *) malloc(1);
      fbuf[0] = '\0';
   }
   
   return(fbuf);
} 

/* Get Config Item */

char *
get_config(char *name, char *filebuf, char gtype)
{
   char *value = NULL;
   char *ptr1;
   char *ptr2;   
   int jump = 0;
   char *tempval = NULL;
   int grow;
   
   ptr1 = filebuf;
   
   while (!jump) {
      
      if ((ptr1 = strstr(ptr1,name)) != NULL) {
         ptr2 = ptr1;
         while (ptr2[0] != '\n' && ptr2[0] != '#' && ptr2 != filebuf)
             ptr2--;
         
         if (ptr2[0] != '#') 
             jump = 1;
         else         
             ptr1++;
         
      } else {
         fprintf(stderr,"Configuration File Error! Could not find field: %s\n",name);
         return("NULL");
      }
      
   }
   
   if (gtype == 'S') {
      if ((ptr1 = strchr(ptr1,' ')) == NULL) {
         fprintf(stderr,"Configuration File Error! Could not find value for field: %s\n",name);
         return("NULL");
      }
      
      while (isblank(ptr1[0]))
          ptr1++;
      
      ptr2 = ptr1;
      
      while (!isblank(ptr2[0]) && ptr2[0] != '\n')
          ptr2++;
      
      value = (char *)statmalloc((ptr2-ptr1)+1);
      value[0] = '\0';
      strncat(value,ptr1,ptr2-ptr1);

   } else if (gtype == 'M') {
   
      if ((ptr1 = strchr(ptr1,'\n')) == NULL) {
         fprintf(stderr,"Configuratin File Error! EXCLUDE DIR Option incorrectly setup!\n");
         return("NULL");
      }
      
      ptr1++;
      
      jump = 0;
      grow = 1;
      
      value = (char *)malloc(1);
      value[0] = '\0';
      
      
      while (!jump) {
         
         ptr2 = ptr1;
         
         while (!isblank(ptr2[0]) && ptr2[0] != '\n')
             ptr2++;
         
         ptr2--;
         
         if (ptr2[0] != '/')
             ptr2++;
         
         tempval = (char *)realloc(tempval,(ptr2-ptr1)+1);
         tempval[0] = '\0';
         strncat(tempval,ptr1,ptr2-ptr1);         
         
         if (strcasecmp(tempval,"END") != 0) {
            grow += (ptr2-ptr1)+2;
            value = (char *)realloc(value,grow);
            strcat(value,"^");
            strcat(value,tempval);
            strcat(value,"^");
         } else jump = 1;
         
         if ((ptr1 = strchr(ptr1,'\n')) == NULL) {
            fprintf(stderr,"Configuratin File Error! EXCLUDE DIR Option incorrectly setup!\n");
            return("NULL");
         }
         
         ptr1++;
         
         while (isblank(ptr1[0]))
             ptr1++;
         
      }
   }
   
   return(value);
   
//   free(value);
}

#ifdef IRIX_CPBK
int isblank(int c)
{
        if (c == ' ' || c == '\n' || c =='\t' ) return 1;

        return 0;
} /* isblank */
#endif

