#ifdef SVGALIB
#include "portable.h"
#include "chinese.h"
#include <vga.h>
#include <vgagl.h>
static void NULL_FUNC();
static vga_modeinfo *screeninfo;
static int mode;
static unsigned int fgcolor,bgcolor,colormask,purefg,purebg;
static char *buf;
static void NULL_FUNC()
{
}

static void graph_mode()
{
  vga_setmode(mode);
  gl_setcontextvga(mode);
}
static void text_mode()
{
  vga_setmode(TEXT);
}
static void graph_clearblock(int sx,int sy,int ex,int ey)
{
  gl_fillbox(sx*ch_fontwidth(),sy,(ex-sx+1)*ch_fontwidth(),ey-sy,bgcolor);
}
static int graph_setcolor(int c)
{
  purebg = (c / 256)%256;
  purefg = c % 256;
  if (colormask == 0)
    {
	fgcolor = purefg;
	bgcolor = purebg;
    }
  else
    {
	fgcolor = purebg;
	bgcolor = purefg;
    }
}
static char *buf;
static void graph_moveleft(int sx,int ex,int y,int c)
{
    int fontwidth,fontheight;
    return;
    fontwidth = ch_fontwidth();
    fontheight = ch_fontheight();
    gl_getbox((sx+c)*fontwidth,y,(ex-sx-c)*fontwidth,fontheight,buf);
    gl_putbox(sx*fontwidth,y,(ex-sx-c)*fontwidth,fontheight,buf);
    gl_fillbox((ex-c)*fontwidth,y,c*fontwidth,fontheight,bgcolor);
}
static void setfontcolor( int fw, int fh, void *_dp ) {
    unsigned char *dp = _dp;
    int i;
    unsigned char sbg,sfg;
    unsigned rfg,rbg;

    sfg = *dp++;
    sbg = *dp++;
    dp = _dp;
    *dp++ = fgcolor;
    *dp++ = bgcolor;
    if (sfg == fgcolor && sbg == bgcolor)
      return;
    i = fw * fh;
    switch (BYTESPERPIXEL) {
      case 1 :
	while (i > 0) {
	    if (*dp==sfg)
	      *dp = fgcolor;
	    else
	      *dp = bgcolor;
	    dp++;
	    i--;
	}
	break;
      case 2 :
	while (i > 0) {
	    if (*(unsigned short *)dp == sfg)
	      *(unsigned short *)dp = fgcolor;
	    else
	      *(unsigned short *)dp = bgcolor;
	    dp += 2;
	    i--;
	}
	break;
      case 3 :
	while (i > 0) {
	    if (*(unsigned short *)dp==sfg || *(dp + 2)==sfg) 
	      {
		  *(unsigned short *)dp = fgcolor;
		  *(dp + 2) = fgcolor >> 16;
	      }
	    else
	      {
		  *(unsigned short *)dp = bgcolor;
		  *(dp + 2) = bgcolor >> 16;
	      }

	    dp += 3;
	    i--;
	}
	break;
      case 4 :
	while (i > 0) {
	    if (*(unsigned int *)dp==sfg)
	      *(unsigned int *)dp = fgcolor;
	    else
	      *(unsigned int *)dp = bgcolor;

	    dp += 4;
	    i--;
	}
	break;
		
    }
}

static void graph_drawtext(int x,int y,char *sp)
{
    setfontcolor(ch_fontwidth(),ch_fontheight(),sp);
    gl_putbox(x*ch_fontwidth(),y,ch_fontwidth(),ch_fontheight(),sp+2);
}

static void graph_drawctext(int x,int y,char *sp)
{
    setfontcolor(ch_fontwidth()*2,ch_fontheight(),sp);
    gl_putbox(x*ch_fontwidth(),y,ch_fontwidth()*2,ch_fontheight(),sp+2);
}


static void expand_font(char *sp,char *dp,int w,int h)
{
/* Convert bit-per-pixel font to byte(s)-per-pixel font */
    unsigned char *f1 = sp;
    unsigned char *f2 = dp;
    int x, y, b;

    *f2++= fgcolor;
    *f2++= bgcolor;
    for (y = 0; y < h; y++)
      for (x = 0; x < w; x++) {
	  if (x % 8 == 0)
	    b = *f1++;
	  if (b & (128 >> (x % 8)))	/* pixel */
	    switch (BYTESPERPIXEL) {
	      case 1 :
		*f2 = fgcolor;
		f2++;
		break;
	      case 2 :
		*(unsigned short *)f2 = fgcolor;
		f2 += 2;
		break;
	      case 3 :
		*(unsigned short *)f2 = fgcolor;
		*(f2 + 2) = fgcolor >> 16;
		f2 += 3;
		break;
	      case 4 :
		*(unsigned int *)f2 = fgcolor;
		f2 += 4;
	    }
	  else	/* no pixel */
	    switch (BYTESPERPIXEL) {
	      case 1 :
		*f2 = bgcolor;
		f2++;
		break;
	      case 2 :
		*(unsigned short *)f2 = bgcolor;
		f2 += 2;
		break;
	      case 3 :
		*(unsigned short *)f2 = bgcolor;
		*(f2 + 2) = bgcolor;
		f2 += 3;
		break;
	      case 4 :
		*(unsigned int *)f2 = bgcolor;
		f2 += 4;
	    }
      }
}


static void graph_invert(int i)
{
    int cc;

    if (i == 0)
      {
	  fgcolor = purefg;
	  bgcolor = purebg;
      }
    else
      {
	  fgcolor = purebg;
	  bgcolor = purefg;
      }
}
static void graph_underline(int i)
{
}
static void graph_drawline(int x1,int y1,int x2,int y2)
{
    gl_line(x1*ch_fontwidth(),y1*ch_fontheight(),
	    x2*ch_fontwidth(),y2*ch_fontheight(),fgcolor);
}
static void graph_scroll(int ul,int dl,int l)
{
    gl_copybox(0,ul+l,WIDTH,dl-ul-l,0,ul);
    gl_fillbox(0,dl-l,WIDTH,l,bgcolor);
}
static void graph_rscroll(int ul,int dl,int l)
{
    gl_copybox(0,ul,WIDTH,dl-ul-l,0,ul+l);
    gl_fillbox(0,ul,WIDTH,l,bgcolor);
}

/* SVGALIB don't support the function to invert a block of image in screen */
static void graph_cursor(int x,int y)
{
    int off;
    char *vp;
    int i,ll;

    if (BYTESPERPIXEL==1)
      {
	  off = BYTEWIDTH*(y+ch_fontheight()-3)+x*ch_fontwidth();
	  vga_setpage(off>>16);
	  vp = VBUF + (off & 0xffff);
	  i = ch_fontwidth();
	  ll = 3;
	  while(ll>0)
	    {
		if (*vp == bgcolor)
		  *vp = fgcolor;
		else
		  *vp = bgcolor;
		i--;
		vp++;
		if (i == 0) {ll--;i= ch_fontwidth();vp+=BYTEWIDTH-ch_fontwidth();}
	    }
      }
}
static int graph_curcolor()
{
    return bgcolor*256+fgcolor;
}
static int graph_fontsize(int x,int y)
{
    return x*y*BYTESPERPIXEL+2;
}


void svga_init_console()
{
  /*vga_allow_non_graphics();*/
  vga_init();  
  mode = vga_getdefaultmode();
  vga_setmode(mode);
  gl_setcontextvga(mode);
  screeninfo = vga_getmodeinfo(mode);
  gl_setrgbpalette();
  buf = (char *) malloc(WIDTH*MAX_FONTSIZE*2);
  if (buf == NULL)
    {
      SYSERR("Can't allocate memory for screen buffer\n");
      exit(-1);
    }
  fgcolor = 7;
  bgcolor = 5;
  colormask = 0;
  mon_grmode = graph_mode;
  mon_textmode = text_mode;
  mon_clearblock = graph_clearblock;
  mon_setcolor = graph_setcolor;
  mon_moveleft = graph_moveleft;
/*  mon_moveright = graph_moveright;*/
  mon_drawctext = graph_drawctext;
  mon_drawtext = graph_drawtext;
  mon_drawcachefont = NULL_FUNC;
  mon_maxcachefont = NULL_FUNC;
  mon_expandfont = expand_font;
  mon_invert = graph_invert;
  mon_underline = graph_underline;
  mon_drawline = graph_drawline;
  mon_scroll = graph_scroll;
  mon_rscroll = graph_rscroll;
  mon_cursor = graph_cursor;
  mon_curcolor = graph_curcolor;
  mon_fontsize = graph_fontsize;
}
#endif


