#include "input.h"
#include "chinese.h"
#include "portable.h"

#define is_num(c) (((c)<='9')&&((c)>='0'))

void get_number(CHAR c)
{
  grpara[grnum] = grpara[grnum]*10+(c-'0');
}

void graphics_line()
{
  int fg,bg;

  switch( grpara[5])
    {
    case GR_LINE:
      fg = COLOR_DEFAULT_FG;
      bg = COLOR_DEFAULT_BG;
      ch_ansicolor(grpara[4],0);
      mon_drawline(grpara[0],grpara[1],grpara[2],grpara[3]);
      ch_ansicolor(fg,bg);
      break;
    case GR_FILLREC:
    case GR_RECTANGLE:
      fg = COLOR_DEFAULT_FG;
      bg = COLOR_DEFAULT_BG;
      ch_ansicolor(grpara[4],0);
      mon_drawline(grpara[0],grpara[1],grpara[0],grpara[3]);
      mon_drawline(grpara[0],grpara[3],grpara[2],grpara[3]);
      mon_drawline(grpara[2],grpara[3],grpara[2],grpara[1]);
      mon_drawline(grpara[2],grpara[1],grpara[0],grpara[1]);
      ch_ansicolor(fg,bg);
      break;
    }
}



void graphics_sequence_set(CHAR c)
{
  /****************************************/
  /* all space in graphics set is ignored */
  /****************************************/

  if (isspace(c))
    return;
  switch(chstate)
    {
    case STATE_LINE:
      if (grnum < 5)
	{
	  if (is_num(c))
	    get_number(c);
	  else if (c == ',') 
	    {
	      grnum++;
	    }
	  else if (c == ';')
	    {
	      graphics_line();
	      chstate = state = STATE_NORMAL;
	    }
	  else
	    {
	      chstate = state = STATE_NORMAL;
	    }
	}
      else if (grnum == 5)
	{
	  if ((grpara[5] == GR_LINE)&&(c == 'F'))
	    {
	      grpara[5] = GR_FILLREC;
	    }
	  else if (c == 'B')
	    {
	      grpara[5] = GR_RECTANGLE;
	    }
	  else if (c == ',')
	    {
	      grnum++;
	    }
	  else 
	    {
	      graphics_line();
	      chstate = state = STATE_NORMAL;
	    }
	}
      else
	{
	  if (is_num(c))
	    get_number(c);
	  else if (c == ',')
	    {
	      grnum++;
	      if (grnum == 10)
		{
		  chstate = state = STATE_NORMAL;
		}
	    }
	  else if (c == ';')
	    {
	      graphics_line();
	      chstate = state = STATE_NORMAL;
	    }
	  else
	    {
	      chstate = state = STATE_NORMAL;
	    }
	}
      break;
    case STATE_CIRCLE:
    case STATE_PAINT:
      chstate = state = STATE_NORMAL;
      SYSERR("Function not implement");
      break;
    }
}


	      
	  

	  

