
#include "config.h"
#include "getopt.h"

#define EXTERN
#include "yodl.h"

int 
main (int argc, char **argv)
{
  int
    i;
  char
   *cp;

  init ();			/* global initializations */

  parse_flags (argc, argv);	/* parse cmdline */

  /* check that all files */
  /* can be accessed */
  message (2, "checking files for readability..");
  for (i = optind; i < argc; i++)
    {
      cp = file_expandname (argv[i]);
      message (2, " (%s)", cp);
      if (strcmp (cp, "-"))	/* don't check stdin */
	if (access (cp, R_OK))
	  error ("file %s unreadable (%s)",
		 cp, strerror (errno));
      free (cp);
    }
  message (2, "\n");

  if (outfname)			/* open output file */
    {
      message (2, "writing output file: %s\n", outfname);
      outf = open_file (outfname, "w");
    }
  else
    message (2, "output to stdout\n");

  for (i = optind; i < argc; i++)	/* process all input files */
    {
      cur_input_file = file_expandname (argv[i]);
      cur_lineno = 0;
      message (2, "input file: %s\n", cur_input_file);
      inf = open_file (cur_input_file, "r");
      parse ();
      close_file (inf);
      message (2, "done with file %s\n", cur_input_file);
      free (cur_input_file);
    }

  inf = 0;			/* handle atexit strings */
  cur_input_file = "atexit-strings";
  cur_lineno = 0;
  for (i = 0; i < natexit_strings; i++)
    lexer_pushstr (atexit_strings[i]);
  parse ();

  close_file (outf);		/* done with parsing */

  return (0);			/* all done */
}

/* For SYSTEMs that need strerror(): */
#ifdef NEEDSTRERROR
char *
strerror (int nr)
{
  extern char
   *sys_errlist[];
  extern int
    sys_nerr;

  if (nr < 0 || nr >= sys_nerr)
    return ("Unknown error.");
  return (sys_errlist[nr]);
}
#endif
