
/* $Id: shrink_width.cc,v 1.1 1997/03/31 23:12:33 dps Exp $ */
/* O(n^2) table width reduction algorithm, n is small in almost all cases */
static void shrink_widths(int ncols, struct rdata *cols, int mtw)
{
    int i, j, tw, maxw;

    for (tw=0, i=0; i<ncols; i++)
	tw+=cols[i].w.width;

    mtw-=ncols;			// Take account of column seperators

    /* Simply reduce the maximum width column width by one until
       enougn has been trimed */
    while (tw>mtw)
    {
	maxw=0; j=-1;
	for (i=0; i<ncols; i++)
	{
	    if (maxw<cols[i].w.width && cols[i].w.align!=ALIGN_DP)
	    {
		j=i;
		maxw=cols[i].w.width;
	    }
	}

	if (j==-1)
	{
	    fprintf(stderr, "Can not shrink overwidth table\n");
	    continue;
	}
	cols[j].w.width--;
	tw--;
    }
}
