/*
 * GUI front-end preference header
 *
 * Preference(also referred to as property) policy:
 * Each instances, such as window and view, has a copy of its own preferences,
 * and the global variable, g_pref, is used as the default value of its copy.
 * When a user modifies the current preferences, each instance of the current
 * view is modified, an g_pref is _also modified simultaneously_
 * as his favorite(default) preference.
 *
 * I'm providing two UIs, i.e. menu and property-box.
 * Color setting is through property-box, and the others are through menus.
 * The reason is that I believe menu is a better UI than property-box.
 * 
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_PREF_H__
#define __GDIFF_PREF_H__

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

	
/* Contant number */
#define DEFAULT_DIFF_ARGS	"-r"

/* gnome-config section (~/.gnome/gtkdiff) */
#define WINDOW_SECTION		"Window"
#define DIR_VIEW_SECTION	"DirectoryView"
#define FILE_VIEW_SECTION	"FileView"

/* WINDOW_SECTION Keys */
#define SHOW_TABS_KEY			"ShowTabs"

/* DIR_VIEW_SECTION Keys */
#define SHOW_PATH_KEY			"ShowPath"
#define DIFF_ARGS_KEY			"DiffArgs"

/* FILE_VIEW_SECTION Keys */
#define PANE_MODE_KEY			"PaneMode"
#define SHOW_LINENUM_KEY		"ShowLineNum"
#define LINE_WRAP_KEY			"LineWrap"
#define FILE1_FGCOLOR_KEY		"File1FGColor"
#define FILE1_BGCOLOR_KEY		"File1BGColor"
#define FILE2_FGCOLOR_KEY		"File2FGColor"
#define FILE2_BGCOLOR_KEY		"File2BGColor"


/*
 * Data structure definitions
 */
/* Preference for window. Kept in GDiffWindow(gui.h) */
struct _WinPref {
	gboolean show_tabs;
};
	
/* Preference for directory view. Kept in GDiffDirViews(gui.h) */
struct _DViewPref {
	gboolean show_path;
	FilesSpecialStatus row_hide_stat_mask;/* Mask to hide dirview's row.
											 Modified by menu (see menu.h). */
	GSList *row_hide_func_list;/* Singly linked list of RowHideFunc() */
	char *diff_args;/* Weird... is this directory view preference? */
};

/* Preference for file view. Kept in GDiffFileViews(gui.h) */
struct _FViewPref {
	PaneMode pane_mode;
	gboolean show_line_num;
	gboolean line_wrap;
	/* Colors for differences on both text widget and overview widget.
	   Note: On overview widget, diff_bg is used for foreground of ranges. */
	GdkColor diff_fg[NUM_COMPARE_FILES];
	GdkColor diff_bg[NUM_COMPARE_FILES];
};

/* Global preference structure */	
struct _Preference {
	WinPref winpref;
	DViewPref dvpref;
	FViewPref fvpref;
};

	
/* Global variable declarations */
Preference g_pref;

/* Global function declarations */
/* properties.c */
extern void properties_init(void);
extern void properties_exit(void);
extern void properties_show(void);

	
#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_PREF_H__ */
