#ifndef __sgml_skip__
#define __sgml_skip__

#include "skip.hh"
#include "container.hh"
#include "refcount.hh"

namespace afilter {

  template <typename T>
  class EmailSkip : public RegionSkipTypes<T> {
  private:
    bool prev_newline;
    bool in_quote;
    int margin;
    int n;

    class QuoteChars : public MutableContainer {
      bool data[256];
    public:
      void insert(const char * s) {
	data[static_cast<unsigned char>(*s)] = true;
      }
      void remove(const char * s) {
	data[static_cast<unsigned char>(*s)] = false;
      }
      void clear() {
	memset(data, 0, sizeof(bool)*256);
      }
      bool have(char c) {
	return data[static_cast<unsigned char>(c)];
      }
      QuoteChars() {clear();}
    };
    RefCount<QuoteChars> is_quote_char;

  public:
    EmailSkip() {abort();}
    EmailSkip(const ConfigData &); 
  
    string name() const {return "email";}
    double order_num() const {return .85;}
  
    bool skip(char c, const Itr *);
  };
}

#endif
