// Not finished. And should check sample encoding as well.

#include "WaveViewDialog.h"
#include "images/waveview.xpm"

#define Inherited WaveViewDialogData

WaveViewDialog::WaveViewDialog(QWidget* parent,	const char* name) : Inherited(parent,name)
{
    setCaption( "Oscilloscope" );
    setFixedSize(width(),height());
    setIcon(*myMainIcon);
	
    myWavePicOrig = new QPixmap(waveview_xpm);
    lastBuffer = 0;
    shown = false;
}

WaveViewDialog::~WaveViewDialog()
{
    delete myWavePicOrig;
}

void WaveViewDialog::show()
{
    shown = true;
    QDialog::show();
}

void WaveViewDialog::setConfig(const AudioConfig& inConfig)
{
    config = inConfig;
}

void WaveViewDialog::done(int r)
{
    shown = false;
    QDialog::done(r);
}

bool WaveViewDialog::isShown()
{
    return shown;
}

void WaveViewDialog::paintWaveformFunc(const void* buffer)
{
    if (!shown)
        return;

    lastBuffer = buffer;
	
    QColor myBeam1Color(0,255,0);  // rgb
    QColor myBeam2Color(0,255,192);  // rgb
	
    QPixmap myWavePic(width(),height());
    QColor myBgColor(0,0,0);  // rgb
    myWavePic.fill(myBgColor);
	
    QPainter paintBuf;
    paintBuf.begin(&myWavePic);
    paintBuf.drawPixmap(0,0,*myWavePicOrig);
    int dy = height()/2;
    int di, i = 0;
    // int di = myAudio.GetBufSize()/width();
    if (config.precision == AudioConfig::BITS_8)
    {
        unsigned char* bBuffer = (unsigned char*)buffer;
        if (config.channels == AudioConfig::STEREO)
        {
            paintBuf.setPen(myBeam1Color);
            di = 2;
            // current point
            paintBuf.moveTo(0,dy);
            for (int x=0; x<width(); x++)
            {
                int y = (bBuffer[i]-128)/2;
                paintBuf.lineTo(x,dy-y);
                i += di;
            }
            paintBuf.setPen(myBeam2Color);
            i = 1;
            // current point
            paintBuf.moveTo(0,dy);
            for (int x=0; x<width(); x++)
            {
                int y = (bBuffer[i]-128)/2;
                paintBuf.lineTo(x,dy-y);
                i += di;
            }
        }
		else  // MONO
		{
            paintBuf.setPen(myBeam1Color);
            di = 1;
            // current point
            paintBuf.moveTo(0,dy);
            for (int x=0; x<width(); x++)
            {
                int y = bBuffer[i]-128;
                paintBuf.lineTo(x,dy-y);
                i += di;
            }
        }
    }
    else  //if (config.precision == AudioConfig::BITS_16)
    {
        short int* wBuffer = (short int*)buffer;
        if (config.channels == AudioConfig::STEREO)
        {
            paintBuf.setPen(myBeam1Color);
            di = 2;
            // current point
            paintBuf.moveTo(0,dy);
            for (int x=0; x<width(); x++)
            {
                int y = (wBuffer[i]/512);
                paintBuf.lineTo(x,dy-y);
                i += di;
            }
            paintBuf.setPen(myBeam2Color);
            i = 1;
            // current point
            paintBuf.moveTo(0,dy);
            for (int x=0; x<width(); x++)
            {
                int y = (wBuffer[i]/512);
                paintBuf.lineTo(x,dy-y);
                i += di;
            }
        }
        else  // MONO
        {
            paintBuf.setPen(myBeam1Color);
            di = 1;
            // current point
            paintBuf.moveTo(0,dy);
            for (int x=0; x<width(); x++)
            {
                int y = (wBuffer[i]/256);
                paintBuf.lineTo(x,dy-y);
                i += di;
            }
        }
    }
	
    paintBuf.end();
		
    QPainter paint(this);
    paint.drawPixmap(0,0,myWavePic);
}

void WaveViewDialog::paintEvent(QPaintEvent*)
{
    if (lastBuffer != 0)
        paintWaveformFunc(lastBuffer);
}

void WaveViewDialog::resizeEvent(QResizeEvent*)
{
    // Disabled.
}
