// --------------------------------------------------------------------------
// HISTORY FILE EVALUATION
// --------------------------------------------------------------------------

#include "HistoryFile.h"

// Keywords.
static const char key_Version[] = "Version=";
static const char key_MaxItems[] = "MaxItems=";
static const char key_AutoAddNo[] = "AutoAdd=No";

HistoryFile::HistoryFile(const char* fileName) : TextFile(fileName)
{
    const char* homeDir = getenv("HOME");
    if (homeDir != NULL)
    {
        configPath = homeDir;
    }
    else
    {
        configPath = "/var/tmp";
    }
    configPath += "/";
    configPath += fileName;
#ifdef WB_DEBUG
    cout << configPath << endl;
#endif
    
    version = 1;
}

// -------------------------------------------------------------------- Input

bool HistoryFile::load(HistoryDialog& dialog)
{
    open(configPath);
    
    int inVersion = version;
    bool inAutoAdd = dialog.autoAdd;
    
    while (status && isGood && !endOfFile())  // line-by-line loop
    {
		readNextLine();
        // Skip blank and comment lines.
        while (status && !endOfFile() && isBlank() || isComment())
        {
            readNextLine();
        };
        // Evaluate line.
#ifdef WB_DEBUG
        cout << "Line " << retLineNum() << ", " << retLineLen() << ": ";
        cout << retLineBuf() << endl;
        cout << "ParseBuf: " << retParseBuf() << endl;
#endif

        if (isKey(key_Version))
            inVersion = atoi(retCurParseBuf());
        else if (isKey(key_MaxItems))
            dialog.maxItems = atoi(retCurParseBuf());
        else if (isKey(key_AutoAddNo))
            inAutoAdd = false;
        
        else
        {
            QString tmpFile = retLineBuf();
            readNextLine();
            QString tmpTitle = retLineBuf();
            dialog.add(tmpFile,tmpTitle);
#ifdef WB_DEBUG
            cout << tmpFile << endl;
            cout << tmpTitle << endl;
#endif
        }
        
    };
    
    dialog.autoAdd = inAutoAdd;  // backdoor! ;-)
    close();
    return isGood;
}

// ------------------------------------------------------------------- Output

bool HistoryFile::save(HistoryDialog& dialog)
{
	bool wasSuccess = false;

#if defined(HAVE_IOS_BIN)
    ofstream toFile(configPath,ios::out|ios::bin|ios::trunc);
#else
    ofstream toFile(configPath,ios::out|ios::binary|ios::trunc);
#endif
	if (toFile)
	{
		toFile 
			<< "# ~/.sidplay-history" << endl
			<< "#" << endl
			<< "# SIDPLAY/X11 history file." << endl
			<< "#" << endl
			<< "# DO NOT edit." << endl
			<< endl;

        toFile << key_Version << version << endl;
        toFile << key_MaxItems << dialog.maxItems << endl;
        
        for (unsigned int n=0; n<dialog.list.count(); n++)
        {
            toFile << dialog.list.at(n)->fileName() << endl;
            toFile << dialog.list.at(n)->title() << endl;
        }
             
        toFile.close();
        wasSuccess = toFile;
    }
	
    return wasSuccess;
}
