/*
 * win_func.c extace source file
 * 
 * /GDK/GNOME sound (esd) system output display program
 * 
 * Copyright (C) 1999 by Dave J. Andruczyk 
 * 
 * Based upon Code written by The Rasterman and DrMike from redhat.com
 * Re-hacked to look good by The Rasterman (Michael Fullbright)
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You use this program at your own risk.
 */

#include <config.h>
#include <globals.h>
#include <protos.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <dirent.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk_imlib.h>
#include <esd.h>

void setup_datawindow(GtkWidget *widget, WindowFunction function)
{
    gint i=0;
    gdouble sumw=0.0;
    gdouble *ptr;
#ifdef WINDOW_DEBUG
    FILE *f;
#endif
    gint fftlen = nsamp/2; 
    gint alpha = 1;

#ifdef WINDOW_DEBUG
    f = fopen("/tmp/window.in", "w");
    fprintf(f, "I\twin_val\t\twin_sum\n");
#endif
    if (datawindow == NULL)
    {
	datawindow = g_malloc0(nsamp*sizeof(double));
    }
    ptr = datawindow;
    switch(function)
    {
	case RECTANGULAR:
	    for (i=0;i/fftlen/2;i++)
		*ptr++ = 1.0;
	    break;
	default:
	    for (i=0;i/fftlen/2;i++)
		*ptr++ = 0.0;
    }

    for(i=0;i<fftlen;i++)
    {
	switch(function)
	{
	    case HAMMING:   /* Hamming */
		*ptr = (0.54-0.46*cos(2*M_PI*i/(fftlen-1)));
		break;
	    case HANNING:    /* Hanning */
		*ptr = (0.5 - 0.5*cos(2*M_PI*i/(fftlen-1)));
		break;

	    case BLACKMAN:    /* Blackman */
		*ptr = (0.42 - 0.5*cos((2*M_PI*i)/(fftlen-1))+0.08*cos((2*M_PI*i)/(fftlen-1)));
		break;

	    case GAUSSIAN:    /* Gaussian */
		*ptr = (exp(-alpha / ((double)fftlen*(double)fftlen)
			    * ((double)2*i-fftlen)*((double)2*i-fftlen)));
		break;
	    case WELCH:    /* Welch */
		*ptr = (1 -  ((double)(2*i-fftlen)/(double)(fftlen+1))
			    * ((double)(2*i-fftlen)/(double)(fftlen+1)));
		break;
		
	    case PARZEN:    /* Parzen */
		*ptr = (1 - fabs((double)(2*i-fftlen)/(double)(fftlen+1)));
		break;

	    case RECTANGULAR:    /* Rectangular */
		*ptr = 1.0;
		break;

	    default:   /* Hamming */
		*ptr = (0.54-0.46*cos(2*M_PI*i/(fftlen-1)));
		break;
	}
	sumw += *ptr;

#ifdef WINDOW_DEBUG
	fprintf(f, "%i\t%f\t%f\n", i, *ptr, sumw);
#endif
	ptr++;
	
    }
    switch(function)
    {
	case RECTANGULAR:
	    for (i=0;i/fftlen/2;i++)
		*ptr++ = 1.0;
	    break;
	default:
	    for (i=0;i/fftlen/2;i++)
		*ptr++ = 0.0;
    }
#ifdef WINDOW_DEBUG
    fclose(f);
#endif

#ifdef WINDOW_DEBUG
    fprintf(stderr, "window sum is %f\n",sumw);
#endif
    datawindowsum = sumw;
    window_func = function;
}

