/*
 * main.c source file for extace
 * 
 * /GDK/GNOME sound (esd) system output display program
 * 
 * Copyright (C) 1998 by Michael Fullbright
 * Re-hacked to look good by The Rasterman
 * 
 * Hacked some more by Dave J. Andruczyk <dave@techdev.buffalostate.edu>
 * to be fully scalable with lots of new options, for tilting the axis's
 * and various other cool stuff.
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You use this program at your own risk.
 */

#include <config.h>
#include <globals.h>
#include <protos.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <dirent.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <esd.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk_imlib.h>

// See globals.h for variable declarations and DEFINES

int main(int argc, char **argv)
{
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *window;
    GtkWidget *button;
    GtkWidget *notebook;
    GtkWidget *frame;
    GtkWidget *sep;
    GtkWidget *label;
    GtkWidget *scale;
    GtkObject *adj1;
    GtkTooltips *tip;
    gchar	frame_name[20];
    gchar	notebook_name[20];
    GSList *group;

    gtk_init(&argc, &argv);
    gdk_imlib_init();

    init();		/* initialize all global variables */
    make_extace_dirs();	/* make conf dir if it doesn't exist */
    read_config();	/* read config file */
    mem_alloc();	/* Alloate memory for the buffers */

    gtk_widget_push_visual(gdk_imlib_get_visual());
    gtk_widget_push_colormap(gdk_imlib_get_colormap());

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    main_win_ptr = window;
    gtk_widget_set_uposition(window, main_x_origin, main_y_origin);
    gtk_window_set_title(GTK_WINDOW(window),"eXtace");
    gtk_container_border_width(GTK_CONTAINER(window),0);
    gtk_signal_connect(GTK_OBJECT(window),"delete_event",
		       GTK_SIGNAL_FUNC(leave),NULL);
    gtk_signal_connect (GTK_OBJECT (window), "button_press_event",
			(GtkSignalFunc) button_notify_event, NULL);
    gtk_signal_connect (GTK_OBJECT (window), "button_release_event",
			(GtkSignalFunc) button_notify_event, NULL);
    gtk_signal_connect (GTK_OBJECT (window), "motion_notify_event",
			(GtkSignalFunc) motion_notify_event, NULL);

    gtk_widget_set_events (window, GDK_EXPOSURE_MASK
			   | GDK_BUTTON_PRESS_MASK
			   | GDK_BUTTON_RELEASE_MASK
			   | GDK_POINTER_MOTION_HINT_MASK
			   | GDK_POINTER_MOTION_MASK);
    gtk_window_set_policy(GTK_WINDOW(window), TRUE,	// allow shrink
			  TRUE, 	// allow grow
			  FALSE);	// auto shrink

    tip = gtk_tooltips_new();


    gtk_widget_realize(window);
    init_gc(window);

    vbox=gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(window), vbox);
    gtk_widget_show(vbox);
    hbox=gtk_hbox_new(TRUE,0);

    button=gtk_button_new_with_label("Wire 3D");
    gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
    gtk_tooltips_set_tip(tip, button, "3D Wireframe FFT", NULL);
    gtk_widget_show(button);
    gtk_signal_connect(GTK_OBJECT(button),"clicked",
		       GTK_SIGNAL_FUNC(button_3d_fft),(gpointer)WIRE_3D);

    button=gtk_button_new_with_label("3D");
    gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
    gtk_tooltips_set_tip(tip, button, "3D Landform FFT", NULL);
    gtk_widget_show(button);
    gtk_signal_connect(GTK_OBJECT(button),"clicked",
		       GTK_SIGNAL_FUNC(button_3d_fft),(gpointer)FILL_3D);

    button=gtk_button_new_with_label("EQ");
    gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
    gtk_tooltips_set_tip(tip, button, "Graphic Equalizer", NULL);
    gtk_widget_show(button);
    gtk_signal_connect(GTK_OBJECT(button),"clicked",
		       GTK_SIGNAL_FUNC(button_2d_fft),NULL);

    button=gtk_button_new_with_label("Scope");
    gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
    gtk_tooltips_set_tip(tip, button, "Gradient Scope", NULL);
    gtk_widget_show(button);
    gtk_signal_connect(GTK_OBJECT(button),"clicked",
		       GTK_SIGNAL_FUNC(button_oscilloscope),NULL);

    button=gtk_button_new_with_label("3D Spikes");
    gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
    gtk_tooltips_set_tip(tip, button, "3D Hi-resolution fft", NULL);
    gtk_widget_show(button);
    gtk_signal_connect(GTK_OBJECT(button),"clicked",
		       GTK_SIGNAL_FUNC(button_3d_detailed),NULL);

    button=gtk_button_new_with_label("Spectragram");
    gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
    gtk_tooltips_set_tip(tip, button, "Spectragram", NULL);
    gtk_widget_show(button);
    gtk_signal_connect(GTK_OBJECT(button),"clicked",
		       GTK_SIGNAL_FUNC(button_specgram),NULL);

    button=gtk_button_new_with_label("About");
    about_but_ptr = button;
    gtk_tooltips_set_tip(tip, button, "About eXtace", NULL);
    gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
    gtk_widget_show(button);
    gtk_signal_connect(GTK_OBJECT(button),"clicked",
		       GTK_SIGNAL_FUNC(button_about),NULL);

    optionsbut=gtk_toggle_button_new_with_label("Options");
    gtk_tooltips_set_tip(tip, optionsbut, "eXtace Advanced Options", NULL);
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(optionsbut), FALSE);
    gtk_box_pack_start(GTK_BOX(hbox),optionsbut,TRUE,TRUE,0);
    gtk_widget_show(optionsbut);
    gtk_signal_connect(GTK_OBJECT(optionsbut),"toggled",
		       GTK_SIGNAL_FUNC(button_options),NULL);

    button=gtk_button_new_with_label("Close");
    gtk_tooltips_set_tip(tip, button, "Close eXtace!!", NULL);
    gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
    gtk_widget_show(button);
    gtk_signal_connect(GTK_OBJECT(button),"clicked",
		       GTK_SIGNAL_FUNC(leave),NULL);

    gtk_widget_show(hbox);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

    disp=gtk_drawing_area_new();
    gtk_signal_connect( GTK_OBJECT(disp),"configure_event",
			(GtkSignalFunc)main_disp_configure, NULL);
    gtk_signal_connect( GTK_OBJECT(disp),"expose_event",
			(GtkSignalFunc)main_disp_expose, NULL);
    gtk_box_pack_start(GTK_BOX(vbox),disp,TRUE,TRUE,0);
    gtk_widget_realize(disp);
    gtk_widget_set_usize(disp,width,height);
    win=disp->window;
    gc=gdk_gc_new(win);
    gdk_gc_copy(gc,disp->style->white_gc);
    pixmap=gdk_pixmap_new(win,width,height,
			  gtk_widget_get_visual(disp)->depth);
    gdk_draw_rectangle( pixmap,
			disp->style->black_gc,
			TRUE, 0,0,
			width,height);
    gdk_window_set_back_pixmap(win,pixmap,0);
    gtk_tooltips_set_tip(tip,disp, "The middle button will get your the color picker", NULL);
    gtk_widget_show(disp);

    // options window
    options = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(options),"eXtace Options");
    gtk_signal_connect(GTK_OBJECT(options),"delete_event",
		       GTK_SIGNAL_FUNC(close_options),optionsbut);
    gtk_container_border_width(GTK_CONTAINER(options),2);

    notebook = gtk_notebook_new ();
    gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
    gtk_container_add(GTK_CONTAINER(options), notebook);
    gtk_widget_show(notebook);

    sprintf(frame_name, "General Options");

    frame = gtk_frame_new(frame_name);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
    gtk_widget_show(frame);

    sprintf(notebook_name, "General Options");
    label = gtk_label_new(notebook_name);
    gtk_notebook_append_page(GTK_NOTEBOOK (notebook), frame, label);

    vbox = gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    label = gtk_label_new("Lag factor");
    gtk_box_pack_start(GTK_BOX(vbox),label,TRUE,TRUE,0);
    gtk_widget_show(label);

    adj1 = gtk_adjustment_new(12.0,0.0,12.0,1.0,1.0,1.0);
    scale = gtk_hscale_new(GTK_ADJUSTMENT(adj1));
    gtk_scale_set_digits(GTK_SCALE(scale),0);
    GTK_ADJUSTMENT (adj1)->value = lag;
    gtk_box_pack_start(GTK_BOX(vbox),scale,TRUE,TRUE,0);
    gtk_range_set_update_policy(GTK_RANGE (scale),
				GTK_UPDATE_CONTINUOUS);
    gtk_signal_connect (GTK_OBJECT (adj1), "value_changed",
			GTK_SIGNAL_FUNC (slider_changed), (gpointer)LAG);
    gtk_widget_show(scale);

    label = gtk_label_new("Number of bands");
    gtk_box_pack_start(GTK_BOX(vbox),label,TRUE,TRUE,0);
    gtk_widget_show(label);

    adj1 = gtk_adjustment_new(32.0,16.0,(float)MAXBANDS+1,1.0,1.0,1.0);
    scale = gtk_hscale_new(GTK_ADJUSTMENT(adj1));
    gtk_scale_set_digits(GTK_SCALE(scale),0);
    GTK_ADJUSTMENT (adj1)->value = bands;
    gtk_box_pack_start(GTK_BOX(vbox),scale,TRUE,TRUE,0);
    gtk_range_set_update_policy(GTK_RANGE (scale),
				GTK_UPDATE_CONTINUOUS);
    gtk_signal_connect (GTK_OBJECT (adj1), "value_changed",
			GTK_SIGNAL_FUNC (slider_changed), (gpointer)BANDS);
    gtk_widget_show(scale);

    label = gtk_label_new("Sensitivity");
    gtk_box_pack_start(GTK_BOX(vbox),label,TRUE,TRUE,0);
    gtk_widget_show(label);

    adj1 = gtk_adjustment_new(200.0,0.0,800.0,1.0,1.0,1.0);
    scale = gtk_hscale_new(GTK_ADJUSTMENT(adj1));
    gtk_scale_set_digits(GTK_SCALE(scale),0);
    GTK_ADJUSTMENT (adj1)->value = sensitivity;
    gtk_box_pack_start(GTK_BOX(vbox),scale,TRUE,TRUE,0);
    gtk_range_set_update_policy(GTK_RANGE (scale),
				GTK_UPDATE_CONTINUOUS);
    gtk_signal_connect (GTK_OBJECT (adj1), "value_changed",
			GTK_SIGNAL_FUNC (slider_changed), (gpointer)SENSE);
    gtk_widget_show(scale);

    label = gtk_label_new("Decay Amount");
    gtk_box_pack_start(GTK_BOX(vbox),label,TRUE,TRUE,0);
    gtk_widget_show(label);

    adj1 = gtk_adjustment_new(1.0,1.0,11.0,1.0,1.0,1.0);
    scale = gtk_hscale_new(GTK_ADJUSTMENT(adj1));
    gtk_scale_set_digits(GTK_SCALE(scale),0);
    GTK_ADJUSTMENT (adj1)->value = decay_val;
    gtk_box_pack_start(GTK_BOX(vbox),scale,TRUE,TRUE,0);
    gtk_range_set_update_policy(GTK_RANGE (scale),
				GTK_UPDATE_CONTINUOUS);
    gtk_signal_connect (GTK_OBJECT (adj1), "value_changed",
			GTK_SIGNAL_FUNC (slider_changed), (gpointer)DECAY);
    gtk_widget_show(scale);

    sep = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(vbox),sep,TRUE, TRUE, 0);
    gtk_widget_show(sep);

    hbox = gtk_hbox_new(TRUE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,FALSE,0);

    button = gtk_toggle_button_new_with_label("Hide Leading Edge");
    gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
    gtk_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (button_handle), (gpointer)SUPPRESS);
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), !show_leader);
    gtk_widget_show(button);

    button = gtk_toggle_button_new_with_label("Enable Decay");
    gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
    gtk_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (button_handle), (gpointer)DECAY);
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), slide);
    gtk_widget_show(button);

    gtk_widget_show(hbox);
    gtk_widget_show(vbox);

    sprintf(frame_name, "Scope Options");

    frame = gtk_frame_new(frame_name);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
    gtk_widget_show(frame);

    sprintf(notebook_name, "Scope Controls");
    label = gtk_label_new(notebook_name);
    gtk_notebook_append_page(GTK_NOTEBOOK (notebook), frame, label);

    vbox = gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    label = gtk_label_new("Scope Mode");
    gtk_box_pack_start(GTK_BOX(vbox),label,TRUE,TRUE,0);
    gtk_widget_show(label);

    button = gtk_radio_button_new_with_label(NULL, "Gradient Scope");
    gtk_box_pack_start(GTK_BOX(vbox),button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT (button), "clicked",
		       GTK_SIGNAL_FUNC (scope_mode), (gpointer)GRAD_SCOPE);
    if ((mode == SCOPE) && (scope_sub_mode == GRAD_SCOPE))
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE);
    gtk_widget_show(button);

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
    button = gtk_radio_button_new_with_label(group, "Dot Scope");
    gtk_box_pack_start(GTK_BOX(vbox),button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT (button), "clicked",
		       GTK_SIGNAL_FUNC (scope_mode), (gpointer)DOT_SCOPE);
    if ((mode == SCOPE) && (scope_sub_mode == DOT_SCOPE))
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE);
    gtk_widget_show(button);

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
    button = gtk_radio_button_new_with_label(group, "Line Scope");
    gtk_box_pack_start(GTK_BOX(vbox),button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT (button), "clicked",
		       GTK_SIGNAL_FUNC (scope_mode), (gpointer)LINE_SCOPE);
    if ((mode == SCOPE) && (scope_sub_mode == LINE_SCOPE))
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE);
    gtk_widget_show(button);
    gtk_widget_show(vbox);

    sprintf(frame_name, "Window Functions");

    frame = gtk_frame_new(frame_name);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
    gtk_widget_show(frame);

    sprintf(notebook_name, "Window Functions");
    label = gtk_label_new(notebook_name);
    gtk_notebook_append_page(GTK_NOTEBOOK (notebook), frame, label);

    vbox = gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(frame), vbox);
    button = gtk_radio_button_new_with_label(NULL,"Hamming");
    gtk_box_pack_start(GTK_BOX(vbox),button,TRUE,TRUE,0);
    if(window_func == HAMMING)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (button), TRUE);
    gtk_signal_connect (GTK_OBJECT (button), "pressed",
			GTK_SIGNAL_FUNC (setup_datawindow), (gpointer)HAMMING);

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
    button = gtk_radio_button_new_with_label(group,"Hanning");
    gtk_box_pack_start(GTK_BOX(vbox),button,TRUE,TRUE,0);
    if(window_func == HANNING)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (button), TRUE);
    gtk_signal_connect (GTK_OBJECT (button), "pressed",
			GTK_SIGNAL_FUNC (setup_datawindow), (gpointer)HANNING);

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
    button = gtk_radio_button_new_with_label(group,"Blackman");
    gtk_box_pack_start(GTK_BOX(vbox),button,TRUE,TRUE,0);
    if(window_func == BLACKMAN)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (button), TRUE);
    gtk_signal_connect (GTK_OBJECT (button), "pressed",
			GTK_SIGNAL_FUNC (setup_datawindow), (gpointer)BLACKMAN);

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
    button = gtk_radio_button_new_with_label(group,"Gaussian");
    gtk_box_pack_start(GTK_BOX(vbox),button,TRUE,TRUE,0);
    if(window_func == GAUSSIAN)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (button), TRUE);
    gtk_signal_connect (GTK_OBJECT (button), "pressed",
			GTK_SIGNAL_FUNC (setup_datawindow), (gpointer)GAUSSIAN);

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
    button = gtk_radio_button_new_with_label(group,"Welch");
    gtk_box_pack_start(GTK_BOX(vbox),button,TRUE,TRUE,0);
    if(window_func == WELCH)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (button), TRUE);
    gtk_signal_connect (GTK_OBJECT (button), "pressed",
			GTK_SIGNAL_FUNC (setup_datawindow), (gpointer)WELCH);

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
    button = gtk_radio_button_new_with_label(group,"Parzen");
    gtk_box_pack_start(GTK_BOX(vbox),button,TRUE,TRUE,0);
    if(window_func == PARZEN)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (button), TRUE);
    gtk_signal_connect (GTK_OBJECT (button), "pressed",
			GTK_SIGNAL_FUNC (setup_datawindow), (gpointer)PARZEN);

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
    button = gtk_radio_button_new_with_label(group,"Rectangular");
    gtk_box_pack_start(GTK_BOX(vbox),button,TRUE,TRUE,0);
    if(window_func == RECTANGULAR)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (button), TRUE);
    gtk_signal_connect (GTK_OBJECT (button), "pressed",
			GTK_SIGNAL_FUNC (setup_datawindow), (gpointer)RECTANGULAR);
    gtk_widget_show_all(vbox);




    dir_win = gtk_window_new(GTK_WINDOW_DIALOG);
    dir_win_ptr = dir_win;
    gtk_widget_set_uposition(dir_win, dir_x_origin, dir_y_origin);
    gtk_window_set_title(GTK_WINDOW(dir_win),"Direction");
    gtk_container_border_width(GTK_CONTAINER(dir_win),2);
    gtk_widget_set_usize(dir_win,dir_width,dir_height);
    gtk_signal_connect(GTK_OBJECT(dir_win),"delete_event",
		       GTK_SIGNAL_FUNC(close_dir_win),NULL);
    gtk_signal_connect (GTK_OBJECT (dir_win), "motion_notify_event",
			(GtkSignalFunc) dir_motion, NULL);
    gtk_signal_connect (GTK_OBJECT (dir_win), "focus_out_event",
			(GtkSignalFunc) dir_save_state, NULL);



    gtk_widget_set_events (dir_win, GDK_EXPOSURE_MASK
			   | GDK_BUTTON_PRESS_MASK
			   | GDK_BUTTON_RELEASE_MASK
			   | GDK_FOCUS_CHANGE_MASK
			   | GDK_POINTER_MOTION_HINT_MASK
			   | GDK_POINTER_MOTION_MASK);

    dir_area = gtk_drawing_area_new();
    gtk_tooltips_set_tip(tip, dir_area, "Drag the pointer ", NULL);
    gtk_drawing_area_size (GTK_DRAWING_AREA (dir_area), 
			   dir_win->allocation.width, 
			   dir_win->allocation.height);
    gtk_signal_connect( GTK_OBJECT(dir_area),"configure_event",
			(GtkSignalFunc)dir_configure, NULL);
    gtk_signal_connect( GTK_OBJECT(dir_area),"configure_event",
			(GtkSignalFunc)update_pointer, NULL);
    gtk_signal_connect( GTK_OBJECT(dir_area),"expose_event",
			(GtkSignalFunc)dir_expose, NULL);

    gtk_container_add(GTK_CONTAINER(dir_win), dir_area);

    gtk_widget_show(dir_area);
    if (dir_win_present)
    {
	gtk_widget_show(dir_win);
	update_pointer();
    }

    gtk_window_set_policy(GTK_WINDOW(dir_win), FALSE,	// allow shrink
			  TRUE, 	// allow grow
			  FALSE);	// auto shrink

    gtk_window_set_policy(GTK_WINDOW(options), FALSE,	// allow shrink
			  TRUE, 	// allow grow
			  FALSE);	// auto shrink

    setup_datawindow(NULL,(WindowFunction)window_func);
    init_colortab();
    open_sound();
    switch (sound_source)
    {
	case ESD:
	    fcntl(sound, F_SETFL, O_NONBLOCK);
	    gdk_input_add(sound, GDK_INPUT_READ | GDK_INPUT_EXCEPTION,
			  handle_read, NULL);
	    break; 
	case ALSA:
	    gdk_input_add(alsa_fd, GDK_INPUT_READ | GDK_INPUT_EXCEPTION,
			  handle_read, NULL);
	    break;
    }

    gtk_widget_show(window);
    if (mode == STARS)// gotta emit it by hand due to config file
	gtk_signal_emit_by_name(GTK_OBJECT(about_but_ptr),"clicked");

    gtk_tooltips_enable(tip);
    ready = 1;		// All set
    gtk_main();
    return 0;
}
