
/*
 *  /GDK/GNOME sound (esd) system output display program
 * 
 * Copyright (C) 1999 by Dave J. Andruczyk 
 * 
 * Based upon Code written by The Rasterman and DrMike from redhat.com
 * Re-hacked to look good by The Rasterman (Michael Fullbright)
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You use this program at your own risk.
 */


#include <globals.h>
#include <configfile.h>
#include <config.h>
#include <enums.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

void init()
{
    // Should actualy get these to/from a text file instead so settings 
    // persist between sessions.. :|  Ohh, how to do it..... :)
    // Initialize ALL variables, should be first functional called from main

    sound_source = ESD;
    left_amplitude = 127;
    right_amplitude = 127;
    axis_type = LOG;
    ready = 0;		// We're NOT ready yet until all main windows are up
    window_func = HAMMING;	// Hamming window (see misc.c)
    nsamp = 2048;	// number of samples per FFT/scope
    bands = 128;	// to start with, should be configurable
    mode = LAND_3D;	// default mode. (3D FFT)
    sub_mode = FILL_3D;	// default 3D mode
    scope_sub_mode = GRAD_SCOPE;	// default Scope mode
    datawindowsum = 0.0;// datawindow (for FFT ONLY)
    sound = -1;		// Is sound device/ESD opened?
    curbuf = 0;		// current buffer being processed
    lag = 6;		// Lag (how many buffers behind)
    pos = 0;		// Postion in the read buffer
    last_is_full = 1;	// its initially ready ??

    seg_height = 4;	// height per segment in 2d spectrum analyzer
    seg_space = 1;	// space between segments in 2d analyzer
    slide = 0;		// slide and decay are tied together
    decay_val = 7;	// decay_val ONLY works with slide "on" (1)
    xdet_scroll = -2;	// detailed scroll in pixels
    zdet_scroll = 2;	// detailed scroll in pixels
    xdet_start= 1.00;	// The 3d DETAILED fft's amount of horizontal
    ydet_start = 0.00;	// detailed y axis start position (percent)
    x3d_start = 1.00;	// The 3d X start point of axis (percentage)
    y3d_start = 0.00;	// The 3d Y start point of axis (percentage)
    xdet_end = 0.00;	// The 3d DETAILED fft's amount of horizontal
    ydet_end = 0.13;	// detailed y axis start position (percent)
    x3d_end = 0.00;	// 3D fft X end point of axis (percentage)
    y3d_end = 0.13;	// 3D fft Y end point of axis (percentage)
    x3d_scroll = -3;	// 3D scroll in pixels x axis
    z3d_scroll = 6;	// 3D scroll in pixels z axis
    det_size = 1;	// detailed size of each pip

    x_draw_width = 0;	// 3D drawing area space after calculations
    y_draw_height = 0;	// 3D drawing area space after calculations

    time_border = 30;	// border on bottom of spectragram display
    x_border = 8;	// border on right side of display
    x_offset = 0;	// 3D X axis offset for centering
    x_shift = 0;	// 3D shift factor(x axis)depending on axis tilt
    x_shift_per_block = 0;// shift in pixels per block for 3D mode

    y_border = 8;	// border on right side of display
    y_offset = 0;	// 3D X axis offset for centering
    y_shift = 0;	// 3D shift factor(x axis)depending on axis tilt
    y_shift_per_block = 0;// shift in pixels per block for 3D mode
    scalefixed = 0;	// its NOT fixed YET. (done dynamically)
    sensefixed = 0;	// its NOT fixed YET. (done dynamically)
    scalefactor = 10.0;	// dynamically figured out by the program
    show_leader = 0;	// show leading edge on 3d landscape fft
    sensitivity= 240;	// Brightness sensitivity, so the colortable
    // WON'T max out when you resize
    ydet_special = 0.0; // Detailed fudge factor. (should be removed!!!)
    to_get = nsamp*2;	// Number of datapoints to read for next buffer
    dir_win_present = 1;// Direction control window
    grad_win_present = 0;// Color picker window
    one_to_fix = 0;	// which end of trace to fix up
    height = 256;
    width  = 370;
    dir_width = 100;
    dir_height = 100;
    main_x_origin = 0;	// window locations on screen
    main_y_origin = 0;	// window locations on screen
    dir_x_origin = width + 0;
    dir_y_origin = 0;
    grad_x_origin = width + 0;
    grad_y_origin = dir_y_origin + dir_height;
    tape_scroll = 2;
    spec_start = 0.90; 	//  at "90%" of the width (9/10ths across)

			   //	Color presets (default colormap)
    start.red=30;start.green=0;start.blue=160;
    pt2.red=160;pt2.green=40;pt2.blue=140;
    pt3.red=210;pt3.green=130;pt3.blue=20;
    pt4.red=240;pt4.green=200;pt4.blue=20;
    end.red=255;end.green=240;end.blue=80;

    win_scale = 0.75;

    return;
}
void read_config(void)
{
    ConfigFile *cfgfile;
    gchar *filename;
    filename = g_strconcat(g_get_home_dir(), "/.eXtace/config", NULL);
    cfgfile = extace_cfg_open_file(filename);
    if (cfgfile)
    {
	extace_cfg_read_int(cfgfile, "Global", "mode", &mode);
	extace_cfg_read_int(cfgfile, "Global", "sub_mode", &sub_mode);
	extace_cfg_read_int(cfgfile, "Global", "scope_sub_mode", &scope_sub_mode);
	extace_cfg_read_int(cfgfile, "Global", "dir_win_present", &dir_win_present);
	extace_cfg_read_int(cfgfile, "Global", "nsamp", &nsamp);
	to_get = nsamp;	// Number of datapoints to read for next buffer
	extace_cfg_read_int(cfgfile, "Global", "window_func", &window_func);
	extace_cfg_read_int(cfgfile, "Global", "bands", &bands);
	extace_cfg_read_int(cfgfile, "Global", "lag", &lag);
	extace_cfg_read_int(cfgfile, "Global", "seg_height", &seg_height);
	extace_cfg_read_int(cfgfile, "Global", "seg_space", &seg_space);
	extace_cfg_read_int(cfgfile, "Global", "slide", &slide);
	extace_cfg_read_int(cfgfile, "Global", "decay_val", &decay_val);
	extace_cfg_read_int(cfgfile, "Global", "xdet_scroll", &xdet_scroll);
	extace_cfg_read_int(cfgfile, "Global", "zdet_scroll", &zdet_scroll);
	extace_cfg_read_float(cfgfile, "Global", "xdet_start", &xdet_start);
	extace_cfg_read_float(cfgfile, "Global", "xdet_end", &xdet_end);
	extace_cfg_read_float(cfgfile, "Global", "ydet_start", &ydet_start);
	extace_cfg_read_float(cfgfile, "Global", "ydet_end", &ydet_end);
	extace_cfg_read_float(cfgfile, "Global", "x3d_start", &x3d_start);
	extace_cfg_read_float(cfgfile, "Global", "x3d_end", &x3d_end);
	extace_cfg_read_float(cfgfile, "Global", "y3d_start", &y3d_start);
	extace_cfg_read_float(cfgfile, "Global", "y3d_end", &y3d_end);
	extace_cfg_read_float(cfgfile, "Global", "spec_start", &spec_start);
	if (spec_start > 1.0)
	    spec_start = .90; 
	extace_cfg_read_int(cfgfile, "Global", "x3d_scroll", &x3d_scroll);
	extace_cfg_read_int(cfgfile, "Global", "z3d_scroll", &z3d_scroll);
	extace_cfg_read_int(cfgfile, "Global", "det_size", &det_size);
	extace_cfg_read_int(cfgfile, "Global", "show_leader", &show_leader);
	extace_cfg_read_int(cfgfile, "Global", "sensitivity", &sensitivity);
	extace_cfg_read_int(cfgfile, "Window", "width", &width);
	extace_cfg_read_int(cfgfile, "Window", "height", &height);
	extace_cfg_read_int(cfgfile, "Window", "main_x_origin", &main_x_origin);
	extace_cfg_read_int(cfgfile, "Window", "main_y_origin", &main_y_origin);
	extace_cfg_read_int(cfgfile, "Window", "grad_win_present", &grad_win_present);
	extace_cfg_read_int(cfgfile, "Window", "grad_x_origin", &grad_x_origin);
	extace_cfg_read_int(cfgfile, "Window", "grad_y_origin", &grad_y_origin);
	extace_cfg_read_int(cfgfile, "Window", "dir_x_origin", &dir_x_origin);
	extace_cfg_read_int(cfgfile, "Window", "dir_y_origin", &dir_y_origin);


	extace_cfg_free(cfgfile);

    }
    g_free(filename);

}
void save_config(void)
{
    gchar *filename;
    ConfigFile *cfgfile;
    gint x;
    gint y;
    filename = g_strconcat(g_get_home_dir(), "/.eXtace/config", NULL);
    cfgfile = extace_cfg_open_file(filename);
    if (!cfgfile)
	cfgfile = extace_cfg_new();

    extace_cfg_write_int(cfgfile, "Global", "mode", mode);
    extace_cfg_write_int(cfgfile, "Global", "sub_mode", sub_mode);
    extace_cfg_write_int(cfgfile, "Global", "scope_sub_mode", scope_sub_mode);
    extace_cfg_write_int(cfgfile, "Global", "dir_win_present", dir_win_present);
    extace_cfg_write_int(cfgfile, "Global", "nsamp", nsamp);
    extace_cfg_write_int(cfgfile, "Global", "window_func", window_func);
    extace_cfg_write_int(cfgfile, "Global", "axis_type", axis_type);
    extace_cfg_write_int(cfgfile, "Global", "bands", bands);
    extace_cfg_write_int(cfgfile, "Global", "lag", lag);
    extace_cfg_write_int(cfgfile, "Global", "seg_height", seg_height);
    extace_cfg_write_int(cfgfile, "Global", "seg_space", seg_space);
    extace_cfg_write_int(cfgfile, "Global", "slide", slide);
    extace_cfg_write_int(cfgfile, "Global", "decay_val", decay_val);
    extace_cfg_write_int(cfgfile, "Global", "xdet_scroll", xdet_scroll);
    extace_cfg_write_int(cfgfile, "Global", "zdet_scroll", zdet_scroll);
    extace_cfg_write_float(cfgfile, "Global", "xdet_start", xdet_start);
    extace_cfg_write_float(cfgfile, "Global", "xdet_end", xdet_end);
    extace_cfg_write_float(cfgfile, "Global", "ydet_start", ydet_start);
    extace_cfg_write_float(cfgfile, "Global", "ydet_end", ydet_end);
    extace_cfg_write_float(cfgfile, "Global", "x3d_start", x3d_start);
    extace_cfg_write_float(cfgfile, "Global", "x3d_end", x3d_end);
    extace_cfg_write_float(cfgfile, "Global", "y3d_start", y3d_start);
    extace_cfg_write_float(cfgfile, "Global", "y3d_end", y3d_end);
    extace_cfg_write_float(cfgfile, "Global", "spec_start", spec_start);
    extace_cfg_write_int(cfgfile, "Global", "x3d_scroll", x3d_scroll);
    extace_cfg_write_int(cfgfile, "Global", "z3d_scroll", z3d_scroll);
    extace_cfg_write_int(cfgfile, "Global", "det_size", det_size);
    extace_cfg_write_int(cfgfile, "Global", "show_leader", show_leader);
    extace_cfg_write_int(cfgfile, "Global", "sensitivity", sensitivity);
    extace_cfg_write_int(cfgfile, "Window", "width", width);
    extace_cfg_write_int(cfgfile, "Window", "height", height);
    gdk_window_get_root_origin((gpointer) main_win_ptr->window, &x, &y);
    extace_cfg_write_int(cfgfile, "Window", "main_x_origin", x);
    extace_cfg_write_int(cfgfile, "Window", "main_y_origin", y);
    extace_cfg_write_int(cfgfile, "Window", "grad_win_present", grad_win_present);
    if (grad_win_present)
    {
	gdk_window_get_root_origin((gpointer) grad_win_ptr->window, &x, &y);
	extace_cfg_write_int(cfgfile, "Window", "grad_x_origin", x);
	extace_cfg_write_int(cfgfile, "Window", "grad_y_origin", y);
    }
    if (dir_win_present)
    {
	gdk_window_get_root_origin((gpointer) dir_win_ptr->window, &x, &y);
	extace_cfg_write_int(cfgfile, "Window", "dir_x_origin", x);
	extace_cfg_write_int(cfgfile, "Window", "dir_y_origin", y);
    }

    extace_cfg_write_file(cfgfile, filename);
    extace_cfg_free(cfgfile);

    g_free(filename);

}
void make_extace_dirs(void)
{
    gchar *filename;

    filename = g_strconcat(g_get_home_dir(), "/.eXtace", NULL);
    mkdir(filename, S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
    g_free(filename);
    filename = g_strconcat(g_get_home_dir(), "/.eXtace/ColorMaps", NULL);
    mkdir(filename, S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
    g_free(filename);

}


void mem_alloc()
{
    int i=0;		// local index for for loop

    /* Malloc ALL buffers, (remember to free them at close) */
    audio_data = g_malloc0(nsamp*sizeof(double));
    audio_left = g_malloc0(nsamp*sizeof(double));
    audio_right = g_malloc0(nsamp*sizeof(double));
    audio_last_l = g_malloc0(nsamp*sizeof(double));
    audio_last_r = g_malloc0(nsamp*sizeof(double));
    raw_fft_out = g_malloc0(nsamp*sizeof(double));
    norm_fft = g_malloc0(nsamp*sizeof(double));
    disp_val = g_malloc0(nsamp*sizeof(int));
    pip_arr = g_malloc0(nsamp*sizeof(int));

    if ((audio_data == NULL) || (audio_left == NULL) ||
	(raw_fft_out == NULL) || (norm_fft == NULL)   ||
	(disp_val == NULL) || (pip_arr == NULL) ||
	(audio_last_l == NULL) || (audio_right == NULL) ||
	(audio_last_r == NULL)) 
    {   
	g_print("Memory could NOT be allocated!!!!, Exiting now!\n");
	exit (-2);
    }
    for (i=0;i<BUFS;i++)
    {
	incoming_buf[i] = g_malloc0(nsamp*2*sizeof(gshort));
	mixdown_buf[i] = g_malloc0(nsamp*sizeof(gshort));
	if ((incoming_buf[i] == NULL) || (mixdown_buf == NULL))

	{
	    g_print("Audio Buffer Memory could NOT be allocated!!!!, Exiting now!\n");
	    exit (2);
	}
    }
}

