/*================================================================
 * external control via pipe interface
 *
 * Copyright (C) 1996-1998 Takashi Iwai
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *================================================================*/

#ifndef EXT_C_H_DEF
#define EXT_C_H_DEF

#include "channel.h"

/* shared memory record */
typedef struct {
	int reset_panel;
	int multi_part;
	int curcs;
	int vel[MAX_MIDI_CHANNELS];
	int maxvel[MAX_MIDI_CHANNELS];
	ChannelStat channels[MAX_MIDI_CHANNELS];
} PanelInfo;

extern PanelInfo *extpanel;
extern int pipe_in, pipe_out;
extern int shmid;
extern int child_pid;

int ext_control_init(int write_pipe, int read_pipe, int do_shmid,
		     int redirect, int argc, char **argv);
void ext_control_end(void);
void ext_pipe_printf(char *fmt, ...);
void ext_pipe_puts(char *str);
void ext_control_load(char *name);
void ext_control_next(void);
void ext_control_prev(void);
void ext_control_restart(void);
void ext_control_stop(void);
void ext_control_pause(void);
void ext_control_kill(void);
void ext_control_jump(int csec);
void ext_control_move(int csec);
void ext_control_chorus(int mode);
void ext_control_reverb(int mode);
void ext_control_volume(int vol);
void ext_control_bass(int vol);
void ext_control_treble(int vol);
void ext_control_keychange(int offset);
void ext_control_fwrd(void);
void ext_control_back(void);

#endif
