#
#  $Id: TaggedText.py,v 1.1 1999/05/27 09:30:49 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU Library General Public License, version 2,
#  as published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public License
#  along with this program; if not, write the Free Software Foundation,
#  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
#
"""
"""

__version__ = '$Id: TaggedText.py,v 1.1 1999/05/27 09:30:49 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'

import formatter, string, re

from Sulfur.Options import Boolean, String

import DTKInput

class TaggedTextDTKInput(DTKInput.DTKInput):
    name = 'TaggedText'
    version = '1.1.0'
    author = 'Rob Tillotson <robt@debian.org>'
    url = ''
    description = 'Text input, with Doc Toolkit tags.'
    options = [
	String('tag-prefix', '\.', 'Tag prefix'),
	Boolean('case-fold-tags', 0, 'Fold tags to lower case'),
	String('tag-regexp', None, 'Regular expression to match tags'),
	]
    
    def convert(self, f, w):
	fmt = formatter.AbstractFormatter(w)
	in_para = 0
	tapi = TagAPI(self.get_option('tag-prefix'),
		      self.get_option('case-fold-tags'),
		      self.get_option('tag-regexp'))  #####
	
	while 1:
	    l = f.readline()
	    if not l: break

	    # this is kind of screwy.  no, this whole thing is kind of screwy.
	    m = tapi.match(l)
	    if m:
		try:
		    l = tapi.process(m, fmt, w)
		except RuntimeError:
		    pass
		if not l: continue

	    if tapi.verbatim:
		fmt.add_literal_data(l)
	    else:
		if not string.strip(l):
		    if in_para:
			in_para = 0
			fmt.end_paragraph(1)
		else:
		    in_para = 1
		    fmt.add_flowing_data(l)
		    

class TagAPI:
    def __init__(self, prefix='.', case_fold=0, tagregex=None, verbatim=0):
	if not tagregex:
	    self.tagregex = "^%(prefix)s\s*(?P<tag>[a-zA-Z0-9/_]+)(?:\s*(?P<arg>.*)\s*)?"
	self.tagprefix = prefix
	self.case_fold = case_fold

	self.tagre = re.compile(self.tagregex % {'prefix': prefix})
	self.verbatim = verbatim

    def match(self, l):
	return self.tagre.match(string.rstrip(l))

    def process(self, m, fmt, w):
	tag, arg = m.group('tag','arg')
	if self.case_fold: tag = string.lower(tag)
	meth = 'tag_' + tag
	if hasattr(self, meth):
	    return apply(getattr(self, meth), (arg, fmt, w))
	elif hasattr(self, 'tag'):
	    return self.tag(tag, arg, fmt, w)

    def tag_TITLE(self, arg, fmt, w):
	w.set_title(arg)
    def tag_BOOKMARK(self, arg, fmt, w):
	w.set_bookmark(arg)
    tag_BM = tag_BOOKMARK
    def tag_H1(self, arg, fmt, w):
	fmt.end_paragraph(1)
	w.send_heading(arg, 1)
    def tag_H2(self, arg, fmt, w):
	fmt.end_paragraph(1)
	w.send_heading(arg, 2)
    def tag_H3(self, arg, fmt, w):
	fmt.end_paragraph(1)
	w.send_heading(arg, 3)
    def tag_H4(self, arg, fmt, w):
	fmt.end_paragraph(1)
	w.send_heading(arg, 4)
    def tag_H5(self, arg, fmt, w):
	fmt.end_paragraph(1)
	w.send_heading(arg, 5)
    def tag_H6(self, arg, fmt, w):
	fmt.end_paragraph(1)
	w.send_heading(arg, 6)
    def tag_PRE(self, *a, **kw):
	self.verbatim = 1
    def tag(self, tag, arg, fmt, w):
	if tag == '/PRE': self.verbatim = 0
	else:
	    raise RuntimeError, 'invalid tag %s' % tag
    def tag_HR(self, arg, fmt, w):
	apply(w.send_hor_rule, (), {'break':'both'})
	
