/* handling functions for installed cdrom drives */

#ifndef CDDRIVES_H
#define CDDRIVES_H

#include <gtk/gtk.h>

#include "selectlist.h"
#include "tracks.h"

#define CDDRIVES_MAXDRIVES 32
/* 32 drives should be enough for everybody ;-) */

typedef struct 
{
	char device[20];
	char scsiid[20];      /* the scsi id is optional but especially
			       * useful for cdda2wav calls as some drives
			       * perform significantly better when accessed
			       * with /dev/sg */
	int cddb;             /* cddb code of the current cd */
	int tracks;
        int mediachange;      /* becomes true if the change detect routine
			       * detects a cd change */
   
	tracks_trackinfo *track[99];	
} cddrives_cdinfo;

typedef struct 
{
	cddrives_cdinfo *drive[CDDRIVES_MAXDRIVES];
	int drivecount;
        int locked; /* this is our semaphore controlling the mt code */
} cddrives_drives_def;

extern cddrives_drives_def cddrives_drives;

void cddrives_init();
/* the following two functions should usually not get called externally */
void cddrives_cdinfo_update(cddrives_cdinfo*);
cddrives_cdinfo *cddrives_cdinfo_create(char *device,char *scsiid);
void cddrives_cdinfo_destroycontent(cddrives_cdinfo*);
void cddrives_cdinfo_destroy(cddrives_cdinfo*);
/* usually called internally only - once by cddrives_init() and whenever
 * a change of preferences occurs */
void cddrives_createdrivelist();
/* called at cd change only */
void cddrives_destroydrivelist();
/* return the cdrom where the cd with a given cddb code resides or NULL if
 * the requested cd couldnt be found */
cddrives_cdinfo *cddrives_getrombycddb(int cddb);
cddrives_cdinfo *cddrives_getrombydevicename(char *);

void cddrives_updateenable();
void cddrives_updatedisable();

#endif // CDDRIVES_H
