/* PIC Processor selection
   Copyright (C) 1998 James Bowman

This file is part of gpasm.

gpasm is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpasm is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpasm; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"

#include "gpasm.h"
#include "symbol.h"
#include "gperror.h"

#define MAX_NAMES 3 /* Maximum number of names a processor can have */

struct px {
  enum pic_processor tag;
  char *define;
  char *names[MAX_NAMES];
};

/* XXXPRO: Need to add a line here for any extra processors.  Please
   keep this list sorted! */

static struct px pics[] = {
  { pic12c508, "__12C508", { "pic12c508",  "p12c508", "12c508" } },
  { pic12c509, "__12C509", { "pic12c509",  "p12c509", "12c509" } },
  { pic16c54, "__16C54", { "pic16c54",  "p16c54", "16c54" } },
  { pic16c55, "__16C55", { "pic16c55",  "p16c55", "16c55" } },
  { pic16c56, "__16C56", { "pic16c56",  "p16c56", "16c56" } },
  { pic16c57, "__16C57", { "pic16c57",  "p16c57", "16c57" } },
  { pic16c58, "__16C58", { "pic16c58",  "p16c58", "16c58" } },
  { pic16c71, "__16C71", { "pic16c71",	"p16c71", "16c71" } },
  { pic16c84, "__16C84", { "pic16c84",	"p16c84", "16c84" } },
  { pic16f84, "__16F84", { "pic16f84",  "p16f84", "16f84" } },
  { sx18, "__SX18", { "sx18ac", "sx18", "sx18" } },
  { sx20, "__SX20", { "sx20ac", "sx20", "sx20" } },
  { sx28, "__SX28", { "sx28ac", "sx28", "sx28" } }
};

#define NUM_PICS	(sizeof(pics) / sizeof(pics[0]))

void select_processor(char *name)
{
  int i, j;
  struct px *found = NULL;

  for (i = 0; i < NUM_PICS; i++) {
    for (j = 0; (j < MAX_NAMES) && (pics[i].names[j] != NULL); j++) {
      if (strcasecmp(name, pics[i].names[j]) == 0) {
	found = &pics[i];
      }
    }
  }
  if (found) {
    if (state.processor == none) {
      state.processor = found->tag;
      add_symbol(state.stDefines, found->define);
    } else if (state.processor != found->tag ) {
      gperror(121, "Processor already selected");
    }
  } else {
    gperror(122, "Unrecognised processor");
  }
}
