/*
** Copyright (C) 10 Feb 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <stdlib.h>

#include "common_gtk.h"
#include "cdrecord_options.h"
#include "vector_commands.h"
#include "locks.h"
#include "command.h"
#include "status_text.h"
#include "contractions.h"
#include "detect_scsi.h"
#include "mainwindow.h"
#include "multisession.h"
#include "read_image.h"
#include "progressbars.h"
#include "globals.h"

GtkWidget *dummy, *eject, *pad, *swab_audio, *dao, *no_image, *use_image, *audio_tracks, *image_path;
GtkWidget *copy_iso_cd, *iso_device_path, *copy_audio_cd, *audio_device_path;
GtkWidget *blank_all, *blank_fast, *fsentry, *need_track_size;
GtkWidget *speed_x[NO_SPEED];
char *speed_string[NO_SPEED] = {"1", "2", "4", "6", "8"};
char *def_image_path = NULL;

/* FIXME: this file is getting too large and covers to much stuff - split it */

static GtkWidget *make_image, *read_image;

static void generate_image(GtkWidget *widget, gpointer data) {
	cmd_v *mkisofs;
	int *output;
	config_cdr_data *cdr_info = (config_cdr_data *)data;

	if (is_running())
		return;

	if ((mkisofs = make_mkisofs_command(FALSE, NULL, cdr_info)) == NULL) {
		not_running();
		return;
	}

	mainwindow_disable_tabs();

	print_cmd(mkisofs);

	if (!(output = popen_re_unbuffered(mkisofs))) {
		g_warning("%s %i: error executing", __FILE__, __LINE__);
		destroy_cmd(mkisofs);
		mainwindow_enable_tabs();
		return;
	}

	destroy_cmd(mkisofs);

	open_mkisofs_progress_bar(output);
}

static void selected_image_dir(GtkWidget *widget, gpointer data) {
/* TODO: check if filename is a filename and not a dir name */
	gtk_entry_set_text(GTK_ENTRY(image_path), gtk_file_selection_get_filename(data));
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(use_image), TRUE);
	gtk_widget_set_sensitive(make_image, TRUE);
	gtk_widget_set_sensitive(read_image, TRUE);
}

static void selected_open_select_dir(GtkWidget *widget, gpointer data) {
	GtkWidget *selector;

	selector = gtk_file_selection_new(_("Please select where to make image:"));
	gtk_signal_connect_object(GTK_OBJECT(selector), "destroy",
			(GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(selector));
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(selector)->ok_button),
			"clicked", (GtkSignalFunc) selected_image_dir, selector);
	gtk_signal_connect_object(
			GTK_OBJECT(GTK_FILE_SELECTION(selector)->ok_button), "clicked",
			(GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(selector));
	gtk_signal_connect_object(
			GTK_OBJECT(GTK_FILE_SELECTION(selector)->cancel_button), "clicked",
			(GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(selector));
/*	gtk_widget_hide(GTK_FILE_SELECTION(selector)->file_list); */
	gtk_widget_show(selector);
}

static void can_make_image(GtkWidget *widget, gpointer *data) {
	gtk_widget_set_sensitive(make_image, TRUE);
	gtk_widget_set_sensitive(read_image, TRUE);
}
static void cannot_make_image(GtkWidget *widget, gpointer *data) {
	gtk_widget_set_sensitive(make_image, FALSE);
	gtk_widget_set_sensitive(read_image, FALSE);
}

static void image_selection(GtkWidget *vbox1, config_cdr_data *cdr_info) {
	GtkWidget *vbox2, *hbox, *open_selector, *frame;
	GSList *vbox2_group = NULL;

	frame = make_frame(_("Data Source"), 5);
	gtk_box_pack_start(GTK_BOX(vbox1), frame, FALSE, TRUE, 0);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_container_add(GTK_CONTAINER(frame), vbox2);

 	no_image = gtk_radio_button_new_with_label(vbox2_group, _("Data Files, no image"));
	vbox2_group = gtk_radio_button_group(GTK_RADIO_BUTTON(no_image));
	gtk_widget_show(no_image);
	gtk_box_pack_start(GTK_BOX(vbox2), no_image, FALSE, TRUE, 0);
      gtk_tooltips_set_tip(tooltips, no_image, _("Do not make a disk image of the files in Data Files. "
				"Pipes output from mkisofs directly to cdrecord on the fly."), NULL);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox, TRUE, TRUE, 0);

	use_image = gtk_radio_button_new_with_label(vbox2_group, _("ISO-9660 Image"));
	vbox2_group = gtk_radio_button_group(GTK_RADIO_BUTTON(use_image));
	gtk_widget_show(use_image);
	gtk_box_pack_start(GTK_BOX(hbox), use_image, FALSE, TRUE, 0);
      gtk_tooltips_set_tip(tooltips, use_image, _("Use a ISO-9660 image to burn from. "
				"You can either use an existing image or make one from the files added to "
				"Data Files (safer, using an image can prevent buffer underruns, but requires "
				"enough free disk space)"), NULL);

	open_selector = gtk_button_new_with_label(_("Choose image location"));
	gtk_widget_show(open_selector);
	gtk_box_pack_start(GTK_BOX(hbox), open_selector, FALSE, TRUE, 0);
      gtk_tooltips_set_tip(tooltips, open_selector, _("Open up a filerequester "
				"and select the path+name of where you want to make the image "
				"(~650MB of free space required) "
				"or the location of an already existing image."), NULL);
	gtk_signal_connect(GTK_OBJECT(open_selector),
			"clicked", (GtkSignalFunc) selected_open_select_dir, open_selector);

	image_path = gtk_entry_new();
	gtk_widget_show(image_path);
	gtk_box_pack_start(GTK_BOX(hbox), image_path, TRUE, TRUE, 0);
      gtk_tooltips_set_tip(tooltips, image_path, _("This is the path to which "
				"the image will be generated or the path to the image to "
				"in case you already have an image"), NULL);
	if (NULL == def_image_path)
		def_image_path = g_strdup("");
	gtk_entry_set_text(GTK_ENTRY(image_path), def_image_path);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox, TRUE, TRUE, 0);

	make_image = gtk_button_new_with_label(_("Create image from files"));
	gtk_widget_show(make_image);
	gtk_box_pack_end(GTK_BOX(hbox), make_image, FALSE, TRUE, 0);
      gtk_tooltips_set_tip(tooltips, make_image, _("Make the iso-image to be burned from Data Files"), NULL);
	gtk_signal_connect(GTK_OBJECT(make_image),
			"clicked", (GtkSignalFunc) generate_image, cdr_info);
	gtk_widget_set_sensitive(make_image, FALSE);

	read_image = gtk_button_new_with_label(_("Read image from CD"));
	gtk_widget_show(read_image);
	gtk_box_pack_end(GTK_BOX(hbox), read_image, FALSE, TRUE, 0);
      gtk_tooltips_set_tip(tooltips, read_image, _("Read the iso-image to be burned from an existing CD-ROM. The image is read from the device specified in the existing ISO-9660 field bellow. Some (all?) IDE burners used with the scsi emulation layer has problems with this. Encountering an error the routine will retry 20 times before giving up."), NULL);
	gtk_signal_connect(GTK_OBJECT(read_image),
			"clicked", (GtkSignalFunc) read_image_from_cd, cdr_info);
	gtk_widget_set_sensitive(read_image, FALSE);

/* copy */

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox, TRUE, TRUE, 0);

	copy_iso_cd = gtk_radio_button_new_with_label(vbox2_group, _("Existing ISO-9660 CD"));
	vbox2_group = gtk_radio_button_group(GTK_RADIO_BUTTON(copy_iso_cd));
	gtk_widget_show(copy_iso_cd);
	gtk_box_pack_start(GTK_BOX(hbox), copy_iso_cd, FALSE, TRUE, 0);
      gtk_tooltips_set_tip(tooltips, copy_iso_cd, _("Copy an data CD directly "
				"(only works with plain ISO-9660 CDs)"), NULL);

	iso_device_path = gtk_entry_new();
	gtk_widget_show(iso_device_path);
	gtk_box_pack_start(GTK_BOX(hbox), iso_device_path, FALSE, TRUE, 0);
#ifdef __FreeBSD__
      gtk_tooltips_set_tip(tooltips, iso_device_path,
			_("Path to device from which to copy (for example /dev/cd0a)"), NULL);
#else
      gtk_tooltips_set_tip(tooltips, iso_device_path,
			_("Path to device from which to copy (for example /dev/hdb or /dev/cdrom)"), NULL);
#endif

/* audio tracks */

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox, TRUE, TRUE, 0);

	audio_tracks = gtk_radio_button_new_with_label(vbox2_group, _("Audio Files"));
	vbox2_group = gtk_radio_button_group(GTK_RADIO_BUTTON(audio_tracks));
	gtk_widget_show(audio_tracks);
	gtk_box_pack_start(GTK_BOX(hbox), audio_tracks, FALSE, TRUE, 0);
      gtk_tooltips_set_tip(tooltips, audio_tracks, _("Make CD-DA (audio CD) "
				"based on tracks selected in Audio Files "
				"(ie the ripped tracks on HD)"), NULL);

/* audio on the fly */

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox, TRUE, TRUE, 0);

	copy_audio_cd = gtk_radio_button_new_with_label(vbox2_group,
			_("Existing audio CD"));
	vbox2_group = gtk_radio_button_group(GTK_RADIO_BUTTON(copy_audio_cd));
	gtk_widget_show(copy_audio_cd);
	gtk_box_pack_start(GTK_BOX(hbox), copy_audio_cd, FALSE, TRUE, 0);
      gtk_tooltips_set_tip(tooltips, copy_audio_cd,
			_("Copy an audio CD directly (on the fly). "
				"This is a track-by-track copy, not a bitwise perfect "
				"copy (gaps for one thing aren't preserved exactly). "
				"This feature is experimental."), NULL);

	audio_device_path = gtk_entry_new();
	gtk_widget_show(audio_device_path);
	gtk_box_pack_start(GTK_BOX(hbox), audio_device_path, FALSE, TRUE, 0);
#ifdef __FreeBSD__
      gtk_tooltips_set_tip(tooltips, audio_device_path,
			_("Path to device from which to copy (for example 0,6,0)"), NULL);
#else
	gtk_tooltips_set_tip(tooltips, audio_device_path,
			_("Path to device from which to copy (for example for cooked style "
				"devices (plain IDE): /dev/hdb, or for SCSI devices in the "
				"\"cdrecord style\": 0,6,0)"), NULL);
#endif

	gtk_signal_connect(GTK_OBJECT(no_image),
			"button_release_event", (GtkSignalFunc) cannot_make_image, NULL);
	gtk_signal_connect(GTK_OBJECT(use_image),
			"button_release_event", (GtkSignalFunc) can_make_image, NULL);
	gtk_signal_connect(GTK_OBJECT(copy_iso_cd),
			"button_release_event", (GtkSignalFunc) cannot_make_image, NULL);
	gtk_signal_connect(GTK_OBJECT(audio_tracks),
			"button_release_event", (GtkSignalFunc) cannot_make_image, NULL);
	gtk_signal_connect(GTK_OBJECT(copy_audio_cd),
			"button_release_event", (GtkSignalFunc) cannot_make_image, NULL);
}

void select_speed(GtkWidget *hbox, GtkWidget *speed[]) {
	GtkWidget *speed_label, *hbox2;
	GSList *hbox2_group = NULL;
	int i;

	speed_label = gtk_label_new(_("Select speed:"));
	gtk_widget_show(speed_label);
	gtk_box_pack_start(GTK_BOX(hbox), speed_label, FALSE, TRUE, 0);

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox2);
	gtk_box_pack_start(GTK_BOX(hbox), hbox2, TRUE, TRUE, 0);

	for (i = 0; i < NO_SPEED; i++) {
		speed[i] = gtk_radio_button_new_with_label(hbox2_group, speed_string[i]);
		hbox2_group = gtk_radio_button_group(GTK_RADIO_BUTTON(speed[i]));
		gtk_widget_show(speed[i]);
		gtk_box_pack_start(GTK_BOX(hbox2), speed[i], FALSE, TRUE, 0);
	}
}

static void record_options(GtkWidget *vbox1) {
	GtkWidget *hbox1, *hbox4, *frame, *vbox, *hbox2, *fslabel;

	frame = make_frame(_("Misc options"), 5);
	gtk_box_pack_start(GTK_BOX(vbox1), frame, FALSE, TRUE, 0);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox1);
	gtk_box_pack_start(GTK_BOX(vbox), hbox1, FALSE, TRUE, 0);

	select_speed(hbox1, speed_x);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(speed_x[2]), TRUE);

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox2);
	gtk_box_pack_start(GTK_BOX(hbox1), hbox2, TRUE, TRUE, 0);

	fsentry = gtk_entry_new();
	gtk_widget_show(fsentry);
	gtk_box_pack_end(GTK_BOX(hbox2), fsentry, FALSE, FALSE, 0);
	fslabel = gtk_label_new(_("FIFO size: "));
	gtk_widget_show(fslabel);
	gtk_box_pack_end(GTK_BOX(hbox2), fslabel, FALSE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, fsentry, _("Set the fifo size (default "
				"is 4 MB, and it will be used if nothing is specified) - goes "
				"directly to the cdrecord fs= option so the syntax is the same "
				"as cdrecords (e.g. 10x53k == 630 kBytes)"), NULL);

	hbox4 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox4);
	gtk_box_pack_start(GTK_BOX(vbox), hbox4, TRUE, TRUE, 0);

	dummy = gtk_check_button_new_with_label(_("Dummy test run"));
	gtk_widget_show(dummy);
	gtk_box_pack_start(GTK_BOX(hbox4), dummy, FALSE, TRUE, 0);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(dummy), TRUE);
	gtk_tooltips_set_tip(tooltips, dummy, _("Go trought every step of the "
				"recording process, but leave the laser off - good way to make "
				"sure everything is ok and that the system can cope with the load."), NULL);

	eject = gtk_check_button_new_with_label(_("Eject disk when done"));
	gtk_widget_show(eject);
	gtk_box_pack_start(GTK_BOX(hbox4), eject, FALSE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, eject, _("Eject the disk when done, some "
				"devices require this."), NULL);

	pad = gtk_check_button_new_with_label(_("Pad"));
	gtk_widget_show(pad);
	gtk_box_pack_start(GTK_BOX(hbox4), pad, FALSE, TRUE, 0);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(pad), TRUE);
	gtk_tooltips_set_tip(tooltips, pad, _("For data tracks: Usable if your drive can't read the "
			"last sectors of a track or if you want to be able to read the CD on an old "
			"Linux system with the ISO-9660 filesystem read ahead bug. For audio tracks: "
			"All audio data to be a multiple of 2352 bytes (as it should be). It's safest to "
			"leave this on, especially for audio tracks."), NULL);

	dao = gtk_check_button_new_with_label(_("DAO"));
	gtk_widget_show(dao);
	gtk_box_pack_start(GTK_BOX(hbox4), dao, FALSE, TRUE, 0);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(dao), FALSE);
	gtk_tooltips_set_tip(tooltips, dao, _("Set Disk At Once mode - needs an image"), NULL);

	swab_audio = gtk_check_button_new_with_label(_("Swab audio"));
	gtk_widget_show(swab_audio);
	gtk_box_pack_start(GTK_BOX(hbox4), swab_audio, FALSE, TRUE, 0);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(swab_audio), TRUE);
	gtk_tooltips_set_tip(tooltips, swab_audio, _("Asume audio data is in byte-swapped "
			"(little-endian) order"), NULL);

	need_track_size = gtk_check_button_new_with_label(_("Get size"));
	gtk_widget_show(need_track_size);
	gtk_box_pack_start(GTK_BOX(hbox4), need_track_size, FALSE, TRUE, 0);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(need_track_size), FALSE);
	gtk_tooltips_set_tip(tooltips, need_track_size,
			_("When burning on the fly, some drives need to know the size "
				"of the track before starting. Enable this option if "
				"your drive requiers this. If burning in DAO mode "
				"on-the-fly all drives must also use this option "
				"(enabled automatically in this case)."), NULL);
}

static void blank_cdrw(cmd_v *cdrecord) {
	int *output;

	mainwindow_disable_tabs();
	if (!(output = popen_re_unbuffered(cdrecord))) {
		g_warning("%s %i: error executing", __FILE__, __LINE__);
		mainwindow_enable_tabs();
		return;
	}

	open_cdrecord_progress_bar(output);
}

static void start_blanking(GtkWidget *widget, gpointer data) {
	cmd_v *cdrecord;
	config_cdr_data *cdr_info = (config_cdr_data *) data;

	if ((cdrecord = make_blank_command(cdr_info)) == NULL)
		return;
	if (is_running()) {
		destroy_cmd(cdrecord);
		return;
	}
	print_cmd(cdrecord);

	blank_cdrw(cdrecord);
	destroy_cmd(cdrecord);
}

static void config_cdrw(GtkWidget *vbox, config_cdr_data *cdr_info) {
	GtkWidget *hbox, *frame, *blank, *blank_button;
	GSList *hbox2_group = NULL;

	frame = make_frame(_("CD-RW"), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(frame), hbox);

	blank = gtk_label_new(_("Blank type:"));
	gtk_widget_show(blank);
	gtk_box_pack_start(GTK_BOX(hbox), blank, FALSE, FALSE, 0);

	blank_all = gtk_radio_button_new_with_label(hbox2_group, _("all"));
	hbox2_group = gtk_radio_button_group(GTK_RADIO_BUTTON(blank_all));
	gtk_widget_show(blank_all);
	gtk_box_pack_start(GTK_BOX(hbox), blank_all, FALSE, FALSE, 0);

	blank_fast = gtk_radio_button_new_with_label(hbox2_group, _("fast"));
	hbox2_group = gtk_radio_button_group(GTK_RADIO_BUTTON(blank_fast));
	gtk_widget_show(blank_fast);
	gtk_box_pack_start(GTK_BOX(hbox), blank_fast, FALSE, FALSE, 0);

	blank_button = gtk_button_new_with_label(_("Blank CD"));
        gtk_tooltips_set_tip(tooltips, blank_button, _("Blank the CD-RW (note that "
				  "the Misc options above apply here, too)"), NULL);
	gtk_widget_show(blank_button);
	gtk_box_pack_start(GTK_BOX(hbox), blank_button, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(blank_button),
			"clicked", (GtkSignalFunc) start_blanking, cdr_info);

}

static void start_audio_on_the_fly(GSList *cdda2wav, cmd_v *cdr, cmd_v *cdr_close) {
	mainwindow_disable_tabs();

	open_cdda2wav_cdrecord_progress_bar(cdda2wav, cdr, cdr_close);
}

static void burn_from_image(cmd_v *cdrecord) {
	int *output;

	mainwindow_disable_tabs();
	if (!(output = popen_re_unbuffered(cdrecord))) {
		g_warning("%s %i: error executing", __FILE__, __LINE__);
		mainwindow_enable_tabs();
		return;
	}

	open_cdrecord_progress_bar(output);
}

static void make_image_and_burn(cmd_v *mkisofs, cmd_v *cdrecord) {
	int *output;

	mainwindow_disable_tabs();
	if (!(output = popen_r_err_in(mkisofs, cdrecord))) {
		g_warning("%s %i: error executing command", __FILE__, __LINE__);
		mainwindow_enable_tabs();
		return;
	}

	open_mkisofs_cdrecord_progress_bar(output);
}

static void start_burning(GtkWidget *widget, gpointer data) {
	cmd_v *cdrecord, *mkisofs;
	config_cdr_data *cdr_info = (config_cdr_data *)data;

	if ((GTK_TOGGLE_BUTTON(use_image)->active) || (GTK_TOGGLE_BUTTON(audio_tracks)->active)
			|| (GTK_TOGGLE_BUTTON(copy_iso_cd)->active)) {
		if ((cdrecord = make_cdrecord_command(cdr_info)) == NULL)
			return;
		if (is_running()) {
			destroy_cmd(cdrecord);
			return;
		}
		print_cmd(cdrecord);
		burn_from_image(cdrecord);
		destroy_cmd(cdrecord);
	} else if (GTK_TOGGLE_BUTTON(copy_audio_cd)->active) {
		cmd_v *cdr_cmd, *cdr_close_cmd;
		GSList *cdda2wav_commands;

		if (is_running())
			return;

		if (NULL == (cdda2wav_commands = make_cdda2wav_list_cmd())) {
			not_running();
			return;
		}

		cdr_cmd = make_cdrecord_cmd_for_audio_track(cdr_info);
		cdr_close_cmd = make_cdrecord_cmd_for_audio_track_fixate(cdr_info);

		start_audio_on_the_fly(cdda2wav_commands, cdr_cmd, cdr_close_cmd);
	} else { /* data image on the fly */
		if ((mkisofs = make_mkisofs_command(FALSE, NULL, cdr_info)) == NULL)
			return;
		if ((cdrecord = make_cdrecord_command(cdr_info)) == NULL) {
			destroy_cmd(mkisofs);
			return;
		}
		if (is_running()) {
			destroy_cmd(mkisofs);
			destroy_cmd(cdrecord);
			return;
		}

		print_cmd(mkisofs);
		print_cmd(cdrecord);

		make_image_and_burn(mkisofs, cdrecord);

		destroy_cmd(mkisofs);
		destroy_cmd(cdrecord);
	}
}

config_cdr_data *create_cdrecord_options(GtkWidget *tab) {
	GtkWidget *vbox, *hbox, *fill, *start_button;
	config_cdr_data *scsi_widget_object;

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(tab), vbox);

	scsi_widget_object = config_cdr(RESET_BUTTON);

	image_selection(vbox, scsi_widget_object);

	multisession_options(vbox);

	record_options(vbox);

	gtk_box_pack_start(GTK_BOX(vbox), scsi_widget_object->widget, FALSE, TRUE, 0);

	config_cdrw(vbox, scsi_widget_object);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

        fill = gtk_label_new("");
	gtk_widget_show(fill);
	gtk_box_pack_start(GTK_BOX(hbox), fill, TRUE, FALSE, 0);

	start_button = gtk_button_new_with_label(_(" Combust! "));
	gtk_tooltips_set_tip(tooltips, start_button, _("Start burning"), NULL);
	gtk_widget_show(start_button);
	gtk_box_pack_start(GTK_BOX(hbox), start_button, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(start_button),
			"clicked", (GtkSignalFunc) start_burning, scsi_widget_object);

	fill = gtk_label_new("");
	gtk_widget_show(fill);
	gtk_box_pack_start(GTK_BOX(hbox), fill, TRUE, FALSE, 0);

	scsi_widget_object->swab_audio = swab_audio;

	return scsi_widget_object;
}
