#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npnews.h"

int NP_News::get_messages( int how_many, int headers )
{
   NP_File spool, read;

   char spool_path[ 1024 ];
   snprintf( spool_path, sizeof spool_path, "%s/.peruser_spool/%s-%s",
             home, address, group );
   int result, count = 0;
   while(( result = spool.opena( spool_path )))
   {
      if ( result == 2 && count++ < 10 )
         continue;
      else
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
               "get_messages(): %s", spool.get_error());
         return 1;
      }
   }

   char read_path[ 1024 ];
   snprintf( read_path, sizeof read_path, "%s:read", spool_path );
   count = 0;
   while(( result = read.opena( read_path )))
   {
      if ( result == 2 && count++ < 10 )
         continue;
      else
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "get_messages(): %s", read.get_error());
         return 1;
      }
   }

   char *pointer;
   if (( pointer = change_group( NULL )) == NULL )
      return 1;

   strtok( pointer, " " );
   int total = atoi( strtok( NULL, " " ));
   int first = atoi( strtok( NULL, " " ));
   int last = atoi( strtok( NULL, " " ));

   if ( !total )
      return 0;

   if ( how_many < 0 )
   {
      rewrite_newsrc( last );
      return 0;
   }

   if ( how_many )
      last_spooled = last - how_many;
   else
      if ( get_last_spooled() )
         return 1;

   if ( last_spooled == last )
      return 0;

   if ( !last_spooled || last_spooled > last || last_spooled < first )
      last_spooled = last - total;

   char buffer[ 1024 ];
   if ( headers )
      if ( has_xover() )
      {
         snprintf( buffer, sizeof buffer, "xover %d-%d\r\n",
                   last_spooled + 1, last );

         if ( put_string( buffer ))
            return 1;

         result = get_xover_data( last_spooled + 1, last, spool, read );
      }
      else
      {
         for( int i = last_spooled + 1; i <= last; ++i )
         {
            snprintf( buffer, sizeof buffer, "head %d\r\n", i );
            if ( put_string( buffer ))
               return 1;
         }
         
         result = get_message_data( last_spooled + 1, last, spool, read );
      }
   else
   {
      for( int i = last_spooled + 1; i <= last; ++i )
      {
         snprintf( buffer, sizeof buffer, "article %d\r\n", i );
         if ( put_string( buffer ))
            return 1;
      }
      
      result = get_message_data( last_spooled + 1, last, spool, read );
   }

   spool.close();
   read.close();

   if ( !result )
      if ( rewrite_newsrc( last ))
         return 1;

   return result;
}
