/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __PAN_SOCKET_H__
#define __PAN_SOCKET_H__

#include <time.h>
#include <gdk/gdk.h>
#include "pan-object.h"

#define PAN_SOCKET(a) ((PanSocket *)a)

typedef struct _PanSocket           PanSocket;

struct _PanSocket
{
	/* parent class */
	PanObject object;

	/* public fields */
	time_t last_action_time;

	/* public fields */
	gboolean error;

	/* private fields */  
	int sockfd;
	gchar* inbuf;
	gchar* endbuf;
	gchar* inptr;
	int line_buffer_size;
	gchar* line_buffer;
};

/* protected */
extern void pan_socket_constructor (PanSocket*, PanObjectDestructor, const gchar*, gint);
extern void pan_socket_destructor (PanObject*);

/* public */
extern PanSocket* pan_socket_new (const gchar* address, gint port);
extern void pan_socket_destroy (PanSocket*);
extern gint pan_socket_putline (PanSocket*, const gchar* line);
extern gint pan_socket_putline_va (PanSocket*, const gchar *, ...);
extern const gint pan_socket_getline (PanSocket*, const gchar** setme);




#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __PAN_SOCKET_H__ */
