/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __SERVER_H__
#define __SERVER_H__

#include <glib.h>
#include "pan-db.h"

typedef struct
{
	gchar   *address;        /* full address, i.e. news.erols.com */
	gchar   *name;	       /* pretty name, i.e. Erols */
	gint     port;	       /* port no., NNTP usually 119, SMTP usually 25 */
	gint     gen_msgid;
	gint     need_auth;        /* need authorization ? */
	gchar   *username;       /* auth username */
	gchar   *password;       /* auth password */
	gboolean posting;      /* is posting allowed? */
	gint     max_connections;  /* max concurrent sockets to this server */
	GSList  *grouplist;
	struct PanDB *db;
}
server_data;

extern void       server_menu_update   (void);
extern void       server_init          (void);
extern void       server_shutdown      (void);
extern GSList*    server_list_load     (void);
extern void       server_free          (server_data *);
extern void*      server_get_attrib_db (void);
extern server_data* server_fetch       (const gchar *name);


#endif /* __SERVER_H__ */
