/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

#include <glib.h>
#include <gtk/gtkclist.h>
#include <gtk/gtkscrolledwindow.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>
#include <libgnomeui/gnome-app.h>
#include <libgnomeui/gnome-app-helper.h>
#include <libgnomeui/gnome-stock.h>

#include "globals.h"
#include "gui.h"
#include "queue-manager.h"
#include "util.h"

typedef struct
{
   GtkWidget *window;
   GtkWidget *queue_clist;
   GtkWidget *appbar;
}
PanQueueManager;

static void queue_manager_hide_cb (GtkWidget*, PanQueueManager*);
static void queue_setup_appbar (void);

static PanQueueManager *pan_queue_manager = NULL;

static GnomeUIInfo qmanager_file_menu[] = {
	GNOMEUIINFO_MENU_OPEN_ITEM (not_implemented, NULL),
	GNOMEUIINFO_MENU_SAVE_ITEM (not_implemented, NULL),
	GNOMEUIINFO_MENU_SAVE_AS_ITEM (not_implemented, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PRINT_ITEM (not_implemented, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_EXIT_ITEM (queue_manager_hide_cb, NULL),	
	GNOMEUIINFO_END
};

static GnomeUIInfo qmanager_edit_menu[] = {
	GNOMEUIINFO_MENU_CUT_ITEM (not_implemented, NULL),
	GNOMEUIINFO_MENU_COPY_ITEM (not_implemented, NULL),
	GNOMEUIINFO_MENU_PASTE_ITEM (not_implemented, NULL),
	GNOMEUIINFO_END
};


static GnomeUIInfo qmanager_main_menu[] = {
	GNOMEUIINFO_MENU_FILE_TREE (qmanager_file_menu),
	GNOMEUIINFO_MENU_EDIT_TREE (qmanager_edit_menu),
	GNOMEUIINFO_MENU_HELP_TREE (help_menu),
	GNOMEUIINFO_END
};

static GnomeUIInfo qmanager_toolbar[] = {
//	GNOMEUIINFO_ITEM_STOCK (N_("Save"), N_("Save this log to a file"), 
//				log_save_cb, GNOME_STOCK_PIXMAP_SAVE),
//	GNOMEUIINFO_ITEM_STOCK (N_("Clear"), N_("Clear this log"),
//				log_clear_cb, GNOME_STOCK_PIXMAP_CLEAR),
	GNOMEUIINFO_ITEM_STOCK (N_("Move Up"), N_("Move the current queue item up one."),
				NULL, GNOME_STOCK_PIXMAP_UP),
	GNOMEUIINFO_ITEM_STOCK (N_("Move Down"), N_("Move the current queue item down one."),
				NULL, GNOME_STOCK_PIXMAP_DOWN),
	GNOMEUIINFO_ITEM_STOCK (N_("Stop All"), N_("Stop all online tasks."),
				NULL, GNOME_STOCK_PIXMAP_STOP),
	GNOMEUIINFO_ITEM_STOCK (N_("Close"), N_("Close the Log Viewer"),
				queue_manager_hide_cb, GNOME_STOCK_PIXMAP_CLOSE),
	GNOMEUIINFO_END

};

static void
queue_setup_appbar (void)
{
	pan_queue_manager->appbar = gnome_appbar_new (FALSE, TRUE, GNOME_PREFERENCES_USER);
	gnome_app_set_statusbar (GNOME_APP(pan_queue_manager->window), GTK_WIDGET (pan_queue_manager->appbar));
}

static void
queue_manager_hide_cb (GtkWidget *widget, PanQueueManager *pqm)
{
	gtk_widget_hide (GTK_WIDGET (pqm->window));
}

void
queue_manager_spawn (void)
{
	GtkWidget *scrolled_window;

	if (pan_queue_manager!=0 && GTK_IS_WIDGET (pan_queue_manager->window)) {
		gtk_widget_show (GTK_WIDGET (pan_queue_manager->window));
		gdk_window_raise (pan_queue_manager->window->window);
		return;
	}

	pan_queue_manager = (PanQueueManager*) g_new0 (PanQueueManager, 1);
	pan_queue_manager->queue_clist = gtk_clist_new (3);

	pan_queue_manager->window =
		gnome_app_new ("Queue", _("Pan - Queue Manager"));
	
	scrolled_window = gtk_scrolled_window_new (NULL, NULL);

	queue_setup_appbar ();

	gnome_app_set_contents (GNOME_APP (pan_queue_manager->window), scrolled_window);
	gnome_app_create_menus_with_data (GNOME_APP (pan_queue_manager->window), qmanager_main_menu, pan_queue_manager);
	gnome_app_create_toolbar_with_data (GNOME_APP (pan_queue_manager->window), qmanager_toolbar, pan_queue_manager);
	gnome_app_install_menu_hints (GNOME_APP(pan_queue_manager->window), qmanager_main_menu);

	gtk_window_set_default_size (GTK_WINDOW (pan_queue_manager->window), 400, 300);

	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);

//	gtk_container_add (GTK_CONTAINER (scrolled_window), pan_queue_manager->queue_clist);

	gtk_widget_show_all (pan_queue_manager->window);
}
