/* $Id: spool.c,v 1.4 1995/11/12 00:05:52 chris Exp $ */

/* $Log: spool.c,v $
 * Revision 1.4  1995/11/12  00:05:52  chris
 * Introduced 'servernick' in serverlist file.  Now used to prepend any
 * output instead of the FQDN.
 *
 * Revision 1.3  1995/10/02  01:37:04  chris
 * Modified some verbosity checks.
 *
 * Revision 1.2  1995/10/01  20:53:59  chris
 * Made some messages verbose-mode only.
 *
 * Revision 1.1  1995/10/01  18:53:17  chris
 * Initial revision
 * */

#include <sys/wait.h>

#include "newsflash.h"
#include "spool.h"
#include "nntp.h"
#include "tcp.h"


static char rcsid[]="$Id: spool.c,v 1.4 1995/11/12 00:05:52 chris Exp $";


/* Process communication
 * =====================
 *
 * control -> data
 *
 *   group <msg-id>  schedule this message-id for retrieve
 *   DONE            all message-ids done
 *
 * data -> control
 *
 * answers are only sent in response to DONE
 *   ERROR
 *   DONE
 */


void data_process(struct serverS *s)
{
  int error=0;
  char line[VERYLONGSTRING];
  char line2[VERYLONGSTRING];
  FILE *local, *remote;
  char *mid, *c;
  char *group;
  int count_already_have=0;
  int count_offered=0;
  int count_not_available=0;
  int count_retrieved=0;
  int count_bytes=0;

  close(s->d2c[0]);
  close(s->c2d[1]);

#ifdef DEBUG
  printf("data process started\n");
#endif

  local=nntp_connect_to_server(localhost);
  if (!local) {
    printf("%s: Could not connect to %s, aborting spool from %s\n",s->nickname,localhost,s->servername);
    write(s->d2c[1],"ERROR\n",6);        /* signal ERROR */
    exit(0);
  }

  remote=nntp_connect_to_server(s->servername);
  if (!remote) {
    nntp_close_connection(local);
    printf("%s: Could not connect to %s, aborting spool\n",s->nickname, s->servername);
    write(s->d2c[1],"ERROR\n",6);        /* signal ERROR */
    exit(0);
  }
  nntp_send_command(remote, "MODE READER\r\n");
  
  while (read(s->c2d[0],line,VERYLONGSTRING)) {
    if (!strncasecmp(line,"DONE",4)) break;
    group=c=line;
    while (*c&&!isspace(*c)) c++;
    *c=0;
    c++;
    while (isspace(*c)) c++;
    mid=c;
    while (*c&&!isspace(*c)) c++;
    *c=0;
    count_offered++;
    sprintf(line2,"IHAVE %s\r\n",mid);
    if (nntp_send_command(local,line2)!=335) {
      if (verbosity>=3) printf("%s: already have %s %s\n",s->servername,group,mid);
      count_already_have++;
      continue;
    }
    sprintf(line2,"ARTICLE %s\r\n",mid);
    if (nntp_send_command(remote,line2)/100!=2) {
      if (verbosity>=3) printf("%s: article not available %s %s\n",s->nickname,group,mid);
      count_not_available++;
      nntp_end_of_article(local);
      continue;
    }
    if (verbosity>=3) printf("%s: retrieving %s %s\n",s->nickname,group,mid);
    else if (verbosity==2) printf("%s: retrieving %s\n",s->nickname,mid);
    while (tcp_read_line(remote,line2,sizeof(line2),TIMEOUT)) {
      if (line2[0]=='.'&&(line2[1]=='\r'||line2[1]=='\n')) break;
      fputs(line2,local);
      count_bytes+=strlen(line2);
    }
    nntp_end_of_article(local);
    count_retrieved++;
  }
  nntp_close_connection(local);
  nntp_close_connection(remote);
  printf("------------------------------------------------------------------\n"
	 "%s: offered:                  %6d\n"
	 "%s: retrieved:                %6d\n"
	 "%s: not available:            %6d\n"
	 "%s: kbytes transferred:       %6d\n",
	 s->nickname,count_offered,s->nickname,count_retrieved,
	 s->nickname,count_not_available,s->nickname,(count_bytes+512)/1024);

  if (!error) write(s->d2c[1],"DONE\n",5);  /* signal DONE */
  else write(s->d2c[1],"ERROR\n",6);        /* signal ERROR */
#ifdef DEBUG
  printf("data process exiting\n");
#endif
  exit(0);
}


void control_process(struct serverS *s, FILE *control)
{
  FILE *l;
  FILE *local;
  char group[LONGSTRING];
  char *c;
  char newnews[LONGSTRING];
  char line[VERYLONGSTRING];
  char line2[VERYLONGSTRING];
  struct tm *t;
  int i;
  int count;

  close(s->d2c[1]);
  close(s->c2d[0]);

  nntp_send_command(control, "MODE READER\r\n");
  t=gmtime(&s->lasttime);
  sprintf(newnews,"NEWNEWS %%s %2.2d%2.2d%2.2d %2.2d%2.2d%2.2d GMT\r\n",
          t->tm_year%100,t->tm_mon+1,t->tm_mday,
          t->tm_hour,t->tm_min,t->tm_sec);
  
  l=fopen(s->grouplist,"r");
  
  if (!l) {
    fprintf(stderr,"%s: Can't open group list %s\n",s->nickname, s->grouplist);
    write(s->c2d[1],"DONE\n",5);
    s->error=1;
    return;
  }

  local=nntp_connect_to_server(localhost);
  if (!local) {
    printf("%s: Could not connect to %s, aborting spool from %s\n",s->nickname, localhost, s->servername);
    write(s->c2d[1],"DONE\n",5);
    s->error=1;
    return;
  }

  while (fgets(group,LONGSTRING,l)) {
    c=group;
    while (*c&&!isspace(*c)) c++;
    *c=0;
#ifdef NOJUNK
    if (!strcmp(group,"junk")) {
      if (verbosity>=2) printf("%s: skipping junk\n",s->nickname);
      continue;
    }
#endif
#ifdef NOCONTROL
    if (!strcmp(group,"control")) {
      if (verbosity>=2) printf("%s: skipping control\n",s->nickname);
      continue;
    }
#endif
    if (verbosity>=1) printf("%s: checking %s\n", s->nickname, group);
    sprintf(line,newnews,group);
    if (nntp_send_command(control, line) != 230) {
      if (verbosity>=2) printf("%s: server refuses to offer articles to us",s->nickname);
      continue;
    }
    count=0;
    while ((i=tcp_read_line(control,line,VERYLONGSTRING,TIMEOUT))) {
      if (*line=='.') break;
      count++;
      c=line;
      while (*c&&*c!='\n'&&*c!='\r') c++;
      *c=0;
      sprintf(line2,"STAT %s\r\n",line);
      if (nntp_send_command(local,line2)/100!=4) {
	if (verbosity>=3) printf("%s: already have %s %s\n",s->nickname,group,line);
	continue;
      }
      sprintf(line2,"%s %s\n",group,line);
      if (!write(s->c2d[1],line2,sizeof(line2))) {
	fprintf(stderr,"%s: pipe to data process broken, giving up\n",s->nickname);
	break;
      }
    }
    if (verbosity>=1) printf("%s: offered %d articles for %s\n",s->nickname,count,group);
  } /* while */
  fclose(l);
  nntp_close_connection(local);
  write(s->c2d[1],"DONE\n",5);
  read(s->d2c[0],line,VERYLONGSTRING);
  if (strncasecmp(line,"DONE",4)) {
    s->error=1;
  }
  else s->error=0;
}



int spool(struct serverS *s)
{
  pid_t pid;
  FILE *control;

  s->error=0;
  if (pipe(s->c2d) || pipe(s->d2c)) {
    fprintf(stderr, "Oops, error opening pipes\n");
    s->error=1;
    return s->error;
  }
  control=nntp_connect_to_server(s->servername);
  if (!control) {
    s->error=1;
    return s->error;
  }
  pid=fork();
  if (pid<0) {
    fprintf(stderr,"%s: Can't fork data process\n",s->nickname);
    nntp_close_connection(control);
    s->error=1;
    return s->error;
  }
  if (!pid) {
    data_process(s);
    exit(0);
  }
  else {
    s->data_pid=pid;
    control_process(s,control);
  }
  nntp_close_connection(control);
  wait(NULL);
#ifdef DEBUG
  printf("%s: Control job exiting with error code %d\n",s->nickname,s->error);
#endif
  return s->error;
}
