#!/bin/sh

if [ "x$1" = "x" -o "x$2" = "x" ] ; then
  echo "Usage: ./makerelease.sh <target> <version> [<arch>]"
  echo "Possible targets: all gtk motif src"
  echo " e.g.: ./makerelease.sh gtk 0.2.0 libc6"
  exit 1;
fi

if [ $1 = gtk ] ; then
  BUILD_GTK=1
elif [ $1 = motif ] ; then
  BUILD_MOTIF=1
elif [ $1 = src ] ; then
  BUILD_SRC=1
elif [ $1 = all ] ; then
  BUILD_GTK=1
  BUILD_MOTIF=1
  BUILD_SRC=1
else 
  echo "Usage: ./makerelease.sh <target> <version> [<arch>]"
  echo "Possible targets: all gtk motif src"
  echo " e.g.: ./makerelease.sh gtk 0.2.0 libc6"
  exit 1;
fi
  

##BUILD 
(cd src; make distclean; 
if [ "x$BUILD_GTK" = "x1" ] ; then
  BUILD_TARGET=BUILD_GTK; export BUILD_TARGET; make -e depend; make -e; 
fi
make clean;
if [ "x$BUILD_MOTIF" = "x1" ] ; then
  BUILD_TARGET=BUILD_MOTIF; export BUILD_TARGET; make -e depend; make -e; 
fi
)


DIR="wxftp-$2"

if [ "x$3" = "x" ] ; then
  NAME="tar.gz"
else
  NAME="$3.tar.gz"
fi

rm -f help.tar help/*~
tar cf help.tar help

rm -rf $DIR
mkdir $DIR

##BINARY
cp help.tar $DIR
cp CHANGES TODO install.sh wxftp.1X README LICENSE Artistic LGPL $DIR

if [ "x$BUILD_GTK" = "x1" ] ; then
#GTK
  cp src/wf $DIR/wxftp
  strip $DIR/wxftp
  tar cf - $DIR | gzip -9c > $DIR.gtk.$NAME
fi

if [ "x$BUILD_MOTIF" = "x1" ] ; then
#DYNAMIC
  cp src/wf-dynamic $DIR/wxftp
  strip $DIR/wxftp
  tar cf - $DIR | gzip -9c > $DIR.dynamic.$NAME

#STATIC
  cp src/wf-static $DIR/wxftp
  strip $DIR/wxftp
  tar cf - $DIR | gzip -9c > $DIR.static.$NAME
fi


if [ "x$BUILD_SRC" = "x1" ] ; then
##SOURCE 
  rm -f $DIR/wxftp $DIR/help.tar
  cp README.source Xbae-4.6.2.tar.gz Xbae-4.6.2.diff makerelease.sh $DIR

  mkdir $DIR/help
  cp help/* $DIR/help
  (cd $DIR/help; rm -rf index.html; ln -s wxftp.html index.html)

  mkdir $DIR/pict
  cp pict/*.xpm $DIR/pict

  mkdir $DIR/icons
  cp icons/*.xpm $DIR/icons

  mkdir $DIR/src
  cp src/Makefile src/*.h src/*.c $DIR/src
  (cd $DIR/src; touch depend.rules)

  tar cf - $DIR | gzip -9c > $DIR.src.tar.gz
fi

rm -rf $DIR

