/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include <pwd.h>
#include "main.h"

extern char *time_string(void);
extern void shost(int *, int);
extern int substitute_string(char *, int);


char *get_alias_user(char *name)
{
   FILE *fp=NULL;
   char str[SONAME], *stra=NULL, *stre=NULL, *strh=NULL;

   if ((fp = fopen((*statstr)->home, "r")) == NULL) {
      return name;
   }

   while (fgets(str, SONAME, fp)) {
      for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
      *stra = '\0';
      for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);
      if (!*stra) continue;
      for (stre=stra; *stre && *stre != ' ' && *stre != '\t'; stre++);
      if (!*stre) continue;
      *stre = '\0';
      if (strcmp("PFTPAUSER", stra)) continue;
      for (stre++; *stre && (*stre == ' ' || *stre == '\t'); stre++);
      if (!*stre) continue;
      for (strh=stre; *strh && *strh != ' ' && *strh != '\t'; strh++);
      if (!*strh) strh = stre;
      else {
         *strh = '\0';
         for (strh++; *strh && (*strh == ' ' || *strh == '\t'); strh++);
      }
      if (!*strh) strh = stre;
      if (!strcmp(name, strh)) {
         if (slfp) fprintf(slfp, "%s Real user name `%s' denied to %s.\n", \
            time_string(), name, (*statstr)->REMOTEHOSTNAME);
         *name = '\0';
         break;
      }
      if (!strcmp("PFTPAUSER", stra) && !strcmp(name, stre)) {
         strcpy(name, strh);
         break;
      }
   }
   fclose(fp);
   return name;
}


short get_var_from_pftprc(FILE *fd, const char *name, char *value, int strnum)
{
   FILE *fp=NULL;
   char str[SONAME], *stra=NULL, *stre=NULL;
   int i=0;
   *value = '\0';

   if (!fd) {
      if ((fp = fopen((*(statstr+strnum))->home, "r")) == NULL) return 0;
      if ((*(statstr+strnum))->host_number) {
         for (i=1; i <= (*(statstr+strnum))->host_number \
            && fgets(str, SONAME, fp); i++) {
            for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
            *stra = '\0';
            if (!*str) {
               i--;
               continue;
            }
            for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);
            if (!*stra) {
               i--;
               continue;
            }

            /*
             * Substitute string with variable or file contents.
             */
            if (*stra == PFTP_SPECIAL_SIGN && \
               (*(stra+1) == 'V' || *(stra+1) == 'F')) {
               if (!substitute_string(str, stra-str)) continue;
            }

            if (!strncmp("PFTP", stra, 4)) i--;
            else if (!*(*(statstr+strnum))->REMOTEHOSTNAME \
                 && (*stra == PFTP_SPECIAL_SIGN || *stra == '.')) i--;
         }
         if (get_var_from_pftprc(fp, name, value, strnum)) return 1;
         rewind(fp);
      }
   }
   else fp = fd;

   while (fgets(str, SONAME, fp)) {
      for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
      *stra = '\0';
      for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);
      if (!*stra) continue;

      /*
       * Substitute string with variable or file contents.
       */
      if (*stra == PFTP_SPECIAL_SIGN && \
         (*(stra+1) == 'V' || *(stra+1) == 'F')) {
         if (!substitute_string(str, stra-str)) continue;
      }

      /*
       * Next host name limits the host specific
       * variable list.
       */
      if (strncmp("PFTP", stra, 4)) break;

      for (stre=stra; *stre && *stre != ' ' && *stre != '\t'; stre++);
      if (!*stre) continue;
      *stre = '\0';

      for (stre++; *stre && (*stre == ' ' || *stre == '\t'); stre++);
      if (!*stre) continue;

      /*
       * Substitute string with variable or file contents.
       */
      if (*stre == PFTP_SPECIAL_SIGN && \
         (*(stre+1) == 'V' || *(stre+1) == 'F')) {
         if (!substitute_string(str, stre-str)) continue;
      }

      /*
       * If variable matches copy the name and return.
       */
      if (!strcmp(name, stra)) {
         strcpy(value, stre);
         fclose(fp);
         return 1;
      }
   }
   if (!fd) fclose(fp);
   return 0;
}


int get_login_and_hostname(char *name, int *portn)
{
   char *tmpstr=NULL, *hname=NULL;
   int dummy=0;
   short has_colon=0, has_at=0;
   MEM_CHECK((hname = (char *) calloc(SONAME, sizeof(char))));
   for (tmpstr=name; *tmpstr && *tmpstr != '@'; tmpstr++) {
      if (*tmpstr == ':') has_colon = 1;
   }
   if (*tmpstr == '@') has_at = 1;
   if (has_colon && has_at) {
      char *tmpp=NULL, *nend=NULL;
      for (tmpstr=name; *tmpstr != ':'; tmpstr++);
      for (nend=tmpstr; *nend; nend++);
      *tmpstr = '\0';
      tmpp = ++tmpstr;
      if (!*((*statstr)->rlogin)) strcpy((*statstr)->rlogin, name);
      for (; *tmpstr && *tmpstr != '@'; tmpstr++);
      *tmpstr = '\0';
      if (!*((*statstr)->pw_passwd)) strcpy((*statstr)->pw_passwd, tmpp);
      tmpstr++;
      if (!*tmpstr) return 1;
      strcpy(hname, tmpstr);
      for (tmpstr=name; tmpstr < nend; tmpstr++) *tmpstr='\0';
      for (tmpstr=hname; *tmpstr && isdigit(*tmpstr); tmpstr++);
      if (!*tmpstr) {
         (*statstr)->host_number = atoi(hname);
         shost(&dummy, (int)0);
      }
      else strcpy(name, hname);
      if (portn) {
         if (!(*statstr)->_PFTP_DAEMON_) {
            (*statstr)->_PFTP_DAEMON_ = BIT_ONE;
            MEM_CHECK((client_destdir = (char *)calloc(LONAME, sizeof(char))));
            strcpy(client_destdir, "~");
            *portn = INETD_PORT;
         }
      }
   }
   else if (has_at) {
      *tmpstr = '\0';
      if (!*((*statstr)->rlogin)) strcpy((*statstr)->rlogin, name);
      tmpstr++;
      if (!*tmpstr) return 1;
      strcpy(hname, tmpstr);
      for (tmpstr=hname; *tmpstr && isdigit(*tmpstr); tmpstr++);
      if (!*tmpstr) {
         (*statstr)->host_number = atoi(hname);
         shost(&dummy, (int)0);
      }
      else strcpy(name, hname);
      if (portn) {
         if (!(*statstr)->_PFTP_DAEMON_ && !*((*statstr)->from)) {
            (*statstr)->_PFTP_DAEMON_ = BIT_TWO;
            if (getpwuid(getuid())) {
               strcpy((*statstr)->from, (char *)getpwuid(getuid())->pw_name);
            }
            else {
               if (stderr) fprintf(stderr, "** Who are you?!\n");
               exit(PFTP_UUSER_ERR);
            }
            *portn = INETD_PORT;
         }
      }
   }
   free(hname);
   return 0;
}
