#ifndef __PRIVATE_LIBNCP_ATOMIC_H__
#define __PRIVATE_LIBNCP_ATOMIC_H__

#ifdef _REENTRANT

#include "config.h"

#ifdef HAVE_ASM_ATOMIC_H

#define __SMP__
#include <asm/atomic.h>

typedef atomic_t ncpt_atomic_t;

#define NCPT_ATOMIC_INIT(v) ATOMIC_INIT(v)
#define ncpt_atomic_read(v) atomic_read(v)
#define ncpt_atomic_set(v,i) atomic_set(v,i)
#define ncpt_atomic_add(i,v) atomic_add(i,v)
#define ncpt_atomic_sub(i,v) atomic_sub(i,v)
#define ncpt_atomic_inc(v) atomic_inc(v)
#define ncpt_atomic_dec(v) atomic_dec(v)
#define ncpt_atomic_dec_and_test(v) atomic_dec_and_test(v)

#else

#include "private/libncp-lock.h"

typedef struct {
	int counter;
	ncpt_mutex_t mutex;
	} ncpt_atomic_t;
	
#define NCPT_ATOMIC_INIT(i) { (i), NCPT_MUTEX_INITIALIZER }

static inline int ncpt_atomic_read(ncpt_atomic_t* v) {
	int tmp;
	
	ncpt_mutex_lock(&v->mutex);
	tmp = v->counter;
	ncpt_mutex_unlock(&v->mutex);
	return tmp;
}

static inline int ncpt_atomic_set(ncpt_atomic_t* v, int i) {
	v->counter = i;
	ncpt_mutex_init(&v->mutex);
	return i;
}

static inline void ncpt_atomic_add(int i, ncpt_atomic_t* v) {
	ncpt_mutex_lock(&v->mutex);
	v->counter += i;
	ncpt_mutex_unlock(&v->mutex);
}

static inline void ncpt_atomic_sub(int i, ncpt_atomic_t* v) {
	ncpt_mutex_lock(&v->mutex);
	v->counter -= i;
	ncpt_mutex_unlock(&v->mutex);
}

#define ncpt_atomic_inc(v) ncpt_atomic_add(1,v)
#define ncpt_atomic_dec(v) ncpt_atomic_sub(1,v)

static inline int ncpt_atomic_dec_and_test(ncpt_atomic_t* v) {
	int tmp;
	
	ncpt_mutex_lock(&v->mutex);
	tmp = !(--v->counter);
	ncpt_mutex_unlock(&v->mutex);
	return tmp;
}

#endif	/* HAVE_ASM_ATOMIC_H */

#else	/* _REENTRANT */

typedef struct { int counter; } ncpt_atomic_t;

#define NCPT_ATOMIC_INIT(i)	{ (i) }

#define ncpt_atomic_read(v)		((v)->counter)
#define ncpt_atomic_set(v,i)		(((v)->counter) = (i))
#define ncpt_atomic_add(i,v)		(((v)->counter) += (i))
#define ncpt_atomic_sub(i,v)		(((v)->counter) -= (i))
#define ncpt_atomic_inc(v)		((v)->counter++)
#define ncpt_atomic_dec(v)		((v)->counter--)
#define ncpt_atomic_dec_and_test(v)	(!(--(v)->counter))

#endif	/* _REENTRANT */

#endif	/* __PRIVATE_LIBNCP_ATOMIC_H__ */
