/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <syslog.h>
#include <sys/time.h>

#include "mserver.h"

extern FILE *insock;
extern FILE *outsock;

extern int csfd;

extern char authuser[];

void mserver_serve(void)
{
	char *retval;
	char temp[1024];
	fd_set rfds;
	struct timeval tv;
	int rtval;

	util_fflush (outsock);
	fprintf(outsock, "READY\n");
	util_fflush (outsock);

	FD_ZERO(&rfds);
	FD_SET(csfd, &rfds);
	tv.tv_usec = 0;
	tv.tv_sec = config_getvalue_int("client_timeout", 0);

	if(tv.tv_sec > 0) {
		rtval = select(csfd+1, &rfds, NULL, NULL, &tv);
		if(!rtval || !FD_ISSET(csfd, &rfds)) {
			syslog (LOG_WARNING, "Could not get input from client (client_timeout) !");
			mserver_cleanup();
			exit(1);
		}
	}

	retval = fgets(temp, 1024, insock);

	if (retval == NULL)
	{
		syslog (LOG_WARNING, "Could not get input from client!");
		mserver_cleanup();
		exit(1);
	}
			
	temp[strlen(temp) - 1] = '\0';
	
	if (temp[strlen(temp) - 1] == 13)
	{
		temp[strlen(temp) - 1] = '\0';
	}
#ifdef DEBUG
	syslog (LOG_DEBUG, "Recieved command: %s", temp);
#endif
		
	if (!strncmp(temp, "QUIT", 1024))
	{	
		mserver_cleanup();
		exit(0);
	}
	else if (!strncmp(temp, "CYCLE", 1024))
	{
		/* Do Nothing */
	}
	else if (!strncmp(temp, "VERSION", 1024))
	{
		mserver_info_var ("version");
	}
	else if (!strncmp(temp, "AUTHOR", 1024))
	{
		mserver_info_var("author");
	}
	else if (!strncmp(temp, "LICENSE", 1024))
	{
		mserver_info_file("license");
	}
	else if (!strncmp(temp, "HISTORY", 1024))
	{
		mserver_info_file("history");
	}
	else if (!strncmp(temp, "CCOUNT", 1024))
	{
		fprintf(outsock, "%d\n", child_count());
	}
	else if (!strncmp(temp, "NETLOAD", 1024))
	{
		mserver_netload();
	}
	else if (!strncmp(temp, "WHO", 1024))
	{
		if (!auth_getverified() && config_getvalue_bool("whoauth", false) == true)
		{
			fprintf(outsock,"ERROR: Authorization required for WHO request\n");
		}
	        else
		{
			shmem_get_who(temp);
			fprintf(outsock, "%s\n", temp);
		}
	}
	else if (!strncmp(temp, "CIP", 1024))
	{
		char addr_str[1024];
		
		if (sock_host(csfd, addr_str, 1024) != 0)
		{
			fprintf(outsock, "IP:UNKNOWN\n");
		}
		else
		{
			fprintf(outsock, "IP:%s\n", addr_str);
		}
	}
	else if (!strncmp(temp, "AUTH", 1024))
	{
		if (auth_getverified() == false)
		{
			fprintf(outsock, "NOT AUTHORIZED\n");
		}
		else
		{
			fprintf(outsock, "AUTHORIZED:%s\n", authuser);
		}
	}
	else if (!strncmp(temp, "STAT", 1024))
	{
		mserver_stat();
	}
	else if (!strncmp(temp, "TIME", 1024))
	{
		mserver_time();
	}
	else if (!strncmp(temp, "CTIME", 1024))
	{
		mserver_ctime();
	}
	else if (!strncmp(temp, "LIST", 1024))
	{
		mserver_list();
	}
	else if (!strncmp(temp, "HALT", 1024))
	{
		mserver_halt_all();
	}
	else if (!strncmp(temp, "KILL", 1024))
	{
		mserver_kill();
	}
	else if (!strncmp(temp, "DIAL", 4))
	{
		if (strlen(temp) < 6)
		{
			fprintf(outsock, "ERROR: Dial syntax: DIAL:Connection\n");
		}
		else
		{
			if (getstat())
			{	
		    		char cname[1024];

				/*
				 * We should complain if a request is made
				 * to dial a different location that the
				 * current connection.
				 */
				cfile_getcname(cname);
				if (strcmp(cname,&temp[5]))
				{
					fprintf(outsock, "ERROR: A connection is already active.\n");
				}
				else
				{
				    mserver_dial(&temp[5], authuser);
				}
			}
			else
			{
				mserver_dial(&temp[5], authuser);
			}
		}
	}
	else if (!strncmp(temp, "CINFO:", 6))
	{
		if (strlen(temp) < 7)
		{
			fprintf(outsock, "ERROR: Connection information syntax: CINFO:Connection\n");
		}
		else
		{
			mserver_cinfo(&temp[6]);
		}
	}
	else if (!strncmp(temp, "USER", 4))
	{
		if (strlen(temp) < 5)
		{
			fprintf(outsock, "ERROR: User syntax: USER:username\n");
		}
		else
		{
			auth_setuser(&temp[5]);
		}
	}
	else if (!strncmp(temp, "PASS", 4))
	{
		if (strlen(temp) < 5)
		{
			fprintf(outsock, "ERROR: Pass syntax: PASS:password\n");
		}
		else
		{
			auth_setpass(&temp[5]);
		}
	}
        else if (!strncmp(temp, "LOCK", 4))
        {
                if (strlen(temp) < 6 || (strcasecmp(&temp[5], "DIAL") && strcasecmp(&temp[5], "KILL")))
                {
                        fprintf(outsock, "ERROR: Lock syntax: LOCK:{DIAL|KILL}\n");
                }
                else
                {
                        mserver_lock(&temp[5]);
                }
        }
        else if (!strncmp(temp, "UNLOCK", 6))
        {
                if (strlen(temp) < 8 || (strcasecmp(&temp[7], "DIAL") && strcasecmp(&temp[7], "KILL")))
                {
                        fprintf(outsock, "ERROR: Unlock syntax: UNLOCK:{DIAL|KILL}\n");
                }
                else
                {
                        mserver_unlock(&temp[7]);
                }
        }
        else if (!strncmp(temp, "LINFO", 1024))
        {
                mserver_linfo();
	}
	else if (!strncmp(temp, "CAPTURE", 7))
	{
                if (strlen(temp) < 9)
                {
                        fprintf(outsock, "ERROR: capture syntax: CAPTURE:NAME\n");
                }
                else
                {
                        mserver_capture(&temp[8]);
                }
	}
        else if (!strncmp(temp, "RELEASE", 1024))
        {
                mserver_release();
	}
	else
	{
		fprintf(outsock, "UNKNOWN\n");
	}
}
