/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <syslog.h>

#include "mserver.h"

extern FILE *outsock;

static unsigned long in_packets, out_packets, in_bytes, out_bytes;

/* for 2.1.102 and later kernels */
static int netload_chains(void)
{
	FILE *f;

	char str[1024];
	char netdev[1024];

	char *iface, *p;
	int tmp;

	f = fopen("/proc/net/dev", "r");

	if (f == NULL)
	{	
		return 0;
	}

	/* skip headers */
	fgets(str, sizeof(str), f);
	fgets(str, sizeof(str), f);
	if (strstr(str, "bytes") == NULL)
	{
		/* old kernel, use ip_acct file insted. */
		fclose(f);
		return 0;
	}

	config_getvalue_cname("netdev", netdev, 1024);
	
	while (fgets(str, sizeof(str), f) != NULL)
	{
		iface = str;
		while (*iface == ' ') iface++;

		p = iface;
		while (*p != ':') p++; *p++ = '\0';

		/* This uses the same netdevice as the stat method, this should
		   be reasonable for most people.  If someone can think of an
                   instance where they can differ please tell me. */
		if (!strcmp(iface, netdev))
		{
			sscanf(p, "%lu %lu %d %d %d %d %d %d %lu %lu", &in_bytes, &in_packets, &tmp, &tmp, &tmp, &tmp, &tmp, &tmp, &out_bytes, &out_packets);
		}
	}

	fclose(f);
	return 1;
}

#define IP_FW_ACCTIN 1000
#define IP_FW_ACCTOUT 2000

static int netload_account(void)
{
	FILE *f;
	char buffer[1024];
	char netdev[1024];
	char *address, *device, *tmp;

	int flags = 0;

	f = fopen("/proc/net/ip_acct", "r");

	if (f == NULL)
	{
		return 0;
	}

	config_getvalue_cname("netdev", netdev, 1024);

	/* Skip over the header line */
	fgets (buffer, sizeof(buffer), f);

	/* format: address device unknown direction unknown unknown packets bytes
           example: 00000000/00000000->00000000/00000000 ppp0 00000000 1000 0 0 149 9708	
	 */
	while (fgets(buffer, sizeof(buffer), f) != NULL)
	{
		address = strtok(buffer, " ");
		syslog(LOG_DEBUG, "address: %s", address);
		device = strtok(NULL, " ");
		syslog(LOG_DEBUG, "device: %s", device);

		if (strcmp(device, netdev))
		{
			continue;
		}

		tmp = strtok(NULL, " ");

		flags = atoi(strtok(NULL, " "));
		syslog(LOG_DEBUG, "flags: %d", flags);

		tmp = strtok(NULL, " ");
		tmp = strtok(NULL, " ");
		tmp = strtok(NULL, " ");
		
		if (flags == IP_FW_ACCTIN)
		{
			sscanf(tmp, "%ld", &in_packets);
			tmp = strtok(NULL, " ");
			sscanf(tmp, "%ld", &in_bytes);
		}
		else if (flags == IP_FW_ACCTOUT)
		{
			sscanf(tmp, "%ld", &out_packets);
			tmp = strtok(NULL, " ");
			sscanf(tmp, "%ld", &out_bytes);
		}
	}

	syslog(LOG_DEBUG, "IN: %d/%d", in_packets, out_bytes);
	syslog(LOG_DEBUG, "OUT: %d/%d", out_packets, out_bytes);

	fclose(f);

	return 1;
}

void mserver_netload(void)
{
	unsigned long start_in_packets, start_out_packets, start_in_bytes, start_out_bytes;

	fprintf(outsock, "BEGIN\n");

	if (!netload_chains() && !netload_account())
		fprintf(outsock, "ERROR: No IP accounting in kernel\n");
	else
	{
		shmem_get_start_netload(&start_in_bytes, &start_in_packets, &start_out_bytes, &start_out_packets);
		if(start_in_bytes > in_bytes || start_in_packets > in_packets || start_out_bytes > out_bytes || start_out_packets > out_packets) {
			netload_init();
			start_in_bytes = in_bytes;
			start_in_packets = in_packets;
			start_out_bytes = out_bytes;
			start_out_packets = out_packets;
		}
		fprintf(outsock, "INPUT: %lu %lu\n", in_bytes - start_in_bytes, in_packets - start_in_packets);
		fprintf(outsock, "OUTPUT: %lu %lu\n", out_bytes - start_out_bytes, out_packets - start_out_packets);
	}
	fprintf(outsock, "END\n");
}

void netload_init(void)
{
	if (!netload_chains() && !netload_account())
	{
		syslog(LOG_WARNING, "No IP accounting in kernel\n");
	}
	else
	{
		shmem_set_start_netload(in_bytes, in_packets, out_bytes, out_packets);
	}
}
