%define version 0.13.0.92

Summary: Interactively creates a Linux packet filtering firewall.
Name: mason
Version: %{version}
Release: 0
Copyright: GPL
Group: Utilities/Network
Source: http://www.pobox.com/~wstearns/mason/mason-%{version}.tar.gz
URL: http://www.pobox.com/~wstearns/mason/index.html
Vendor: William Stearns
Packager: William Stearns <wstearns@pobox.com>
BuildRoot: /tmp/mason-buildroot

%description
Mason creates a firewall that exactly matches the types of 
TCP/IP traffic flowing in, out and through a Linux computer.
It can be used to create a full firewall or add rules to an
existing firewall.

%prep
%setup

%build

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/doc/mason-%{version}
mkdir -p $RPM_BUILD_ROOT/usr/man/man1
mkdir -p $RPM_BUILD_ROOT/var/lib/mason
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%doc COPYING index.html mason.lsm mason.sgml mason.txt mason.html mason-1.html mason-2.html mason-3.html mason-4.html mason-5.html mason-6.html mason-7.html mason-8.html mason-9.html mason-10.html mason-11.html toc.gif prev.gif next.gif mason.pdb
%attr(600,root,root) %config	/etc/masonrc
%attr(755,root,root)			/etc/rc.d/init.d/firewall
%attr(755,root,root)			/usr/bin/mason
%attr(755,root,root)			/usr/bin/mason-gui-text
%attr(644,root,root)			/usr/man/man1/mason.1
%attr(644,root,root)			/usr/man/man1/mason-gui-text.1
%attr(755,root,root) %dir		/var/lib/mason
%attr(755,root,root)			/var/lib/mason/baserules.sample
%attr(755,root,root)			/var/lib/mason/masonlib
%attr(644,root,root)			/var/lib/mason/moreservices
%attr(644,root,root)			/var/lib/mason/nmap-services
%attr(755,root,root)			/var/lib/mason/regression-test

%pre
if [ -f /etc/masonrc ]; then
	rm -f /etc/masonrc.oldversion
	cp -pf /etc/masonrc /etc/masonrc.oldversion
fi

%post
if [ ! -f /var/lib/mason/baserules ]; then
	cp -p /var/lib/mason/baserules.sample /var/lib/mason/baserules
	chown root.root /var/lib/mason/baserules
	chmod 700 /var/lib/mason/baserules
fi

if [ ! -f /var/lib/mason/newrules ]; then
	touch /var/lib/mason/newrules
	chown root.root /var/lib/mason/newrules
	chmod 700 /var/lib/mason/newrules
fi

if [ -f /etc/masonrc.oldversion ]; then
	cat /etc/masonrc.oldversion | grep -v '^#' | grep -v '^$' >>/etc/masonrc
	rm -f /etc/masonrc.oldversion
	echo "NOTE - your old settings have been appended to the end of the " >>/etc/masonrc.README
	echo "new /etc/masonrc." >>/etc/masonrc.README
fi

