#ifndef __UI_THEMES_H
#define __UI_THEMES_H

#define THEME_FLAG_BG_SCROLLABLE        0x0001
#define THEME_FLAG_BG_SCALED            0x0002
#define THEME_FLAG_BG_SHADED            0x0004

typedef struct
{
    gchar *plugin;

    GList *formatlist;
    gchar **format;
}
PLUGIN_THEME_REC;

typedef struct
{
    gchar *path;

    gchar *name;
    gchar **format;

    gint default_color;
    gchar *bg_pixmap;
    gchar *font;
    gint flags;

    GHashTable *plugins;

    gpointer gui_data;
}
THEME_REC;

extern GList *themes;
extern THEME_REC *current_theme;

THEME_REC *theme_create(gchar *path, gchar *name);
void theme_destroy(THEME_REC *rec);

void ui_themes_init(void);
void ui_themes_deinit(void);

#endif
