#ifndef __BANS_H
#define __BANS_H

/*

Defines signals:

ban_add():
 "ban add", ban_rec

ban_remove():
 "ban remove", ban_rec

ban_exception_add():
 "ban exception add", ban_rec

ban_exception_remove():
 "ban exception remove", ban_rec

*/

typedef struct
{
    gchar *ban;
    gchar *setby;
    time_t time;
}
BAN_REC;

BAN_REC *ban_add(CHANNEL_REC *channel, gchar *ban, gchar *nick, time_t time);
void ban_remove(CHANNEL_REC *channel, gchar *ban);

BAN_REC *ban_exception_add(CHANNEL_REC *channel, gchar *ban, gchar *nick, time_t time);
void ban_exception_remove(CHANNEL_REC *channel, gchar *ban);

/* Get ban mask */
gchar *ban_get_mask(CHANNEL_REC *channel, gchar *nick);

void bans_init(void);
void bans_deinit(void);

#endif
