/*
 gtk-sample.c : GTK part of sample plugin for irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include <irssi-plugin-gui.h>
#include "sample.h"

static void plugin_setup(gpointer widget, PLUGIN_REC *plugin)
{
    static GtkWidget *dialog = NULL;

    setup("plugin "PLUGIN_NAME" setup", &dialog, plugin);
}

gboolean plugin_sample_gtk_init(PLUGIN_REC *plugin)
{
    plugin_sample_gtk_setup_init(plugin);
    signal_emit("plugin add menu", 3, "Settings...", plugin_setup, plugin);

    return TRUE;
}

void plugin_sample_gtk_deinit(PLUGIN_REC *plugin)
{
}
