/*      
 * iroffer by PMG
 * Copyright (C) 1999 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"

/* remote admin for iroffer */

int setupdccchatout(char *nick) {
   SIGNEDSOCK int addrlen;
   int listenport;
   char *tempstr;
   
   addrlen = sizeof (struct sockaddr_in);
   
   if (dccchat != 1000) {
      writedccchat("Another DCC Chat Request Received");
      writedccchat("Bye.");
      ioutput1(0,OUT_S,NULL,"DCC CHAT Switch");
      FD_CLR(dccchat, &readset);
      close(dccchat);
      dccchat = 1000;
      highestsock();
      }
   
   if ((dccchatlisten = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
      outerror(1,"Could Not Create Socket, Aborting");
      dccchatlisten = 1000;
      return 1;
      }

   bzero (&dccchatlistenaddr, sizeof (struct sockaddr_in));
      
   dccchatlistenaddr.sin_family = AF_INET;
   dccchatlistenaddr.sin_addr.s_addr = INADDR_ANY;
  
   dccchatlistenaddr.sin_port = htons(0);
   
   if ((bind(dccchatlisten, (struct sockaddr *)&dccchatlistenaddr, sizeof(struct sockaddr_in))) < 0) {
      outerror(1,"Couldn't Bind to Socket, Aborting");
      dccchatlisten = 1000;
      return 1;
      }
      

   if ((getsockname (dccchatlisten, (struct sockaddr *)&dccchatlistenaddr, &addrlen)) < 0) {
      outerror(1,"Couldn't get Port Number, Aborting");
      dccchatlisten = 1000;
      return 1;
      }
      
   listenport = ntohs (dccchatlistenaddr.sin_port);
 
   if (listen (dccchatlisten, 1) < 0) {
      outerror(1,"Couldn't Listen, Aborting");
      dccchatlisten = 1000;
      return 1;
      }
  
   highestsock();
   
   tempstr = mycalloc(maxtextlength,"setupdccchatout_tempstr");
   snprintf(tempstr,maxtextlength-1,"PRIVMSG %s :\1DCC CHAT CHAT %lu %d\1",nick,ourip,listenport);
   writeserver(tempstr);
   mydelete(tempstr);
   
   return 0;
   }

void setupdccchataccept() {
   SIGNEDSOCK int addrlen;
   char *tempstr, *tempstr2;
   
   if (dccchat != 1000) {
      writedccchat("Another DCC Chat Request Received");
      writedccchat("Bye.");
      ioutput1(0,OUT_S,NULL,"DCC CHAT Switch");
      FD_CLR(dccchat, &readset);
      close(dccchat);
      dccchat = 1000;
      highestsock();
      }
   
   addrlen = sizeof (struct sockaddr_in);
   if ((dccchat = accept(dccchatlisten, (struct sockaddr *) &dccchatlistenaddr, &addrlen)) < 0) {
      outerror(1,"Accept Error, Aborting");
      FD_CLR(dccchatlisten, &readset);
      close(dccchatlisten);
      dccchatlisten = 1000;
      highestsock();
      return;
      }
   
   FD_CLR(dccchatlisten, &readset);
   close(dccchatlisten);
   dccchatlisten = 1000;
   
   tempstr = mycalloc(maxtextlength,"setupdccchataccept_tempstr");
   tempstr2 = mycalloc(maxtextlength,"setupdccchataccept_tempstr2");
   getuptime(tempstr2,0);
   snprintf(tempstr,maxtextlength-2,"Welcome to %s\niroffer v%s [%s] By PMG - %s\n"
                                    "    running %s\n"
                                    " \nEnter Your Password:\n",
      user_nick,VERSION,VERSIONDATE,osstring,tempstr2);
   write(dccchat,tempstr,strlen(tempstr));
   mydelete(tempstr);
   mydelete(tempstr2);
   
   dccchatin = 0;

   highestsock();
   }

int setupdccchat(char *line) {
   struct sockaddr_in remoteip;
   struct sockaddr_in localaddr;
   struct hostent *localhost;
   char *ip, *port;
   SIGNEDSOCK int addrlen;
   char *tempstr, *tempstr2;
   
   if (dccchat != 1000) {
      writedccchat("Another DCC Chat Request Received");
      writedccchat("Bye.");
      ioutput1(0,OUT_S,NULL,"DCC CHAT Switch");
      FD_CLR(dccchat, &readset);
      close(dccchat);
      dccchat = 1000;
      highestsock();
      }
   
   ip = getpart(line,7,"setupdccchat_ip");
   port = getpart(line,8,"setupdccchat_port");
   
   if ( !ip || !port ) {
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   
   ioutput1(0,OUT_S|OUT_L,"0;35","DCC Chat Requested");
   
   bzero ((char *) &remoteip, sizeof (remoteip));
   
   dccchat = socket( AF_INET, SOCK_STREAM, 0);
   if (dccchat < 0) {
      outerror(1,"Socket Error");
      dccchat = 1000;
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   
   port[strlen(port)-1] = '\0';
   
   remoteip.sin_family = AF_INET;
   remoteip.sin_port = htons(atoi(port));
   
/*   if (( remotehost = gethostbyname(hostname)) == NULL) { */
/*      outerror(1,"Can't Resolve Server Host"); */
/*      return 1; */
/*      } */
   
   remoteip.sin_addr.s_addr = htonl(atoul(ip));

/*   memcpy(&remoteip.sin_addr, *((struct in_addr **)remotehost->h_addr_list), sizeof(struct in_addr)); */
   
   if (virthost) {
      if (!vhost_ip) outerror(0,"virthost = yes, but no vhost_ip set");
      bzero((char*)&localaddr, sizeof(struct sockaddr_in));
      localaddr.sin_family = AF_INET;
      localaddr.sin_port = 0;
      if (( localhost = gethostbyname(vhost_ip)) == NULL) {
         outerror(1,"Can't Resolve Virtual Host");
         dccchat = 1000;
         mydelete(ip);
         mydelete(port);
         return 1;
         }
      memcpy(&localaddr.sin_addr, *((struct in_addr **)localhost->h_addr_list), sizeof(struct in_addr));
      if (bind(dccchat, (struct sockaddr *) &localaddr, sizeof(localaddr)) < 0) {
         outerror(1,"Couldn't Bind To Virtual Host");
         dccchat = 1000;
         mydelete(ip);
         mydelete(port);
         return 1;
         }
      }

   alarm(CTIMEOUT);
   if (connect(dccchat, (struct sockaddr *) &remoteip, sizeof(remoteip)) < 0) {
      outerror(1,"Connection to DCC Chat Failed");
      dccchat = 1000;
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   alarm(0);
   
   addrlen = sizeof (remoteip);
   if (getsockname(dccchat,(struct sockaddr *) &remoteip, &addrlen) < 0) {
      outerror(1,"Couldn't get sock name");
      dccchat = 1000;
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   
   if (debug) {
      ioutput1(1,OUT_S,"0;33","dccchat socket = ");
      ioutputi(OUT_S,dccchat);
      ioutput1(3,OUT_S,"0;33","");
      }

   highestsock();
   
   tempstr = mycalloc(maxtextlength,"setupdccchat_tempstr");
   tempstr2 = mycalloc(maxtextlength,"setupdccchat_tempstr2");
   getuptime(tempstr2,0);
   snprintf(tempstr,maxtextlength-2,"Welcome to %s\niroffer v%s [%s] By PMG - %s\n"
                                    "    running %s\n"
                                    " \nEnter Your Password:\n",
      user_nick,VERSION,VERSIONDATE,osstring,tempstr2);
   write(dccchat,tempstr,strlen(tempstr));
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(ip);
   mydelete(port);
   dccchatin = 0;
   
   return 0;
   }

void parsedccchat(char* line) {
   char *linec = mycalloc(maxtextlength,"parsedccchat_linec");
   userinput ui;
   char *tempstr;
   strcpy(linec,line);
   caps(linec);
   
   if (!dccchatin) {
      if (!strcmp(linec,adminpass)) {
         dccchatin = 1;
         writedccchat(" \n*** Entering DCC Chat Admin Interface\n"
                      "*** For Help type \"help\"\n");
         if (messagefile) {
            tempstr = mycalloc(maxtextlength,"parsedccchat_tempstr");
            msglog_howmany(tempstr);
            writedccchat(tempstr);
            mydelete(tempstr);
            }
         writedccchat(" \n");

         }
      else {
         ioutput1(0,OUT_S|OUT_L|OUT_D,"0;35","DCC CHAT: Incorrect password");
         FD_CLR(dccchat, &readset);
         close(dccchat);
         dccchat = 1000;
         highestsock();
         }
      }
   else if (!strcmp(linec,"QUIT")) {
      ioutput1(0,OUT_S|OUT_L,"0;35","DCC CHAT: QUIT");
      writedccchat("Bye.");
      FD_CLR(dccchat, &readset);
      close(dccchat);
      dccchat = 1000;
      highestsock();
      }
   else {
      if (!attop) gototop();
      if (debug)
         ioutput2(0,OUT_S,"0;36",">DCC>: ",line);
      /*remoteadmin(NULL,msg3,msg4,line); */
      u_fillwith_dcc(&ui,line);
      u_parseit(&ui);

      }
   
   mydelete(linec);
   }

void writedccchat(char *str) {
   if (!str) return;
   
   write(dccchat,str,strlen(str));
   
   if ( str[strlen(str)-1] != '\n')
      write (dccchat,"\n",1);
   
   if (debug)
      ioutput2(0,OUT_S,"0;36","<DCC<: ",str);

   }

void writestatus() {
   char *tempstr,*tempstr2;
   
   tempstr = mycalloc(maxtextlength,"writestatus_tempstr");
   tempstr2 = mycalloc(maxtextlengthshort,"writestatus_tempstr2");
   
   getstatusline(tempstr);
   writedccchat(tempstr);
   
   mydelete(tempstr);
   mydelete(tempstr2);
   
   }

