/*      
 * iroffer by PMG
 * Copyright (C) 1999 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 */

#if !defined _IROFFER_DEFINES
#define _IROFFER_DEFINES

#define  VERSION "0.1b32"
#define  VERSIONDATE "September 9th, 1999"
#define  VERSIONDATEUTC 936926751  /* "date +'%s'" */
#define  RELEASE 1

/* don't touch these! */
/*       Send Flood Protection */
#define  SND_FPROT 1
/*       Receive Flood Protection */
#define  RCV_FPROT 1
/*       Ping The Server */
#define  PING_SRVR 1
/*       User Can't Request The Same File Twice */
#define  USER_MAXS 1
/*       User Can't Get In A Queue Twice */
#define  USER_QUE  1
/*       Timeout Transfers */
#define  XFR_TMOUT 1
/*       Try Servers Infinately */
#define  TRYSVRINF 1

/* other stuff */
/*       How long to sleep in ms in main loop */
#define  WAITTIME  25
/*       How many lines to read in from /proc/net/tcp in linux */
#define  SOCKLINES 256
/*       Use Escape Seq to make status/input line */
#define  USESCREEN 1
/*       Use Escape Seq to make color */
#define  USECOLOR  1
/*       XDCC SAVE on Shutdown */
#define  SAVEQUIT  1
/*       Print Socket Info */
#define  PRINTSOCK 0
/*       Print Efficiency Info */
#define  SHOWEFF   0
/*       Print loop Debug Info */
#define  LOOPDEBUG 0

/*       Max Servers */
#define  MAXSRVS   50
/*       Max Channels */
#define  MAXCHNLS  50
/*       Max Server Send Queue Lines */
#define  MAXSENDQ  300
/*       Max Queue Size */
#define  MAXQUEUE  100
/*       Max Number of Transfers */
#define  MAXTRANS  100
/*       Max number of adminhosts */
#define  MAXAHOST  10
/*       Max XDCC's Offered */
#define  MAXXDCCS  100
/*       max size for xdcc list queue */
#define  MAXXLQUE  5

/*       Do Safe Mem Checking */
#define  MEMINFOCHECK 1
/*       Max meminfo */
#define  MAXMEMINFO 2000

/*       Connection Timeout In Seconds */
#define  CTIMEOUT  10
/*       How Long to Wait Until We Giveup On A Non-responding Server */
#define  SRVRTOUT  240

/*       max number of people to keep track of in ignore list */
#define  MAXIGNL  40
/*       tollerance for ignore, seconds/request to decrement bucket */
#define  IGN_TL    10
/*       threshhold for ignore, number of requests in bucket */
#define  IGN_ON    8
/*       threshhold for un-ignore, number of requests in bucket */
#define  IGN_OFF   0

/*       weight for speed calcualtion in dcl */
#define  DCL_SPDW  0.9
/*       time until minspeed checking becomes active */
#define  MIN_TL    60

/*       max 4K blocks to write per cycle */
#define  tbufsize  10

/*       notify level for server queue */
#define  srvqnotify  30


/* plugin support, comment it out if you want to use a */
/*       plugin, see plugins.cpp for details */
#define  _IROFFER_NOPLUGINS

/* free'ing just leads to trouble if we dont check first and then make NULL */
#define mydelete(x) {mydeletepart(x); x=NULL;}

#define  maxtextlengthshort 60
#define  maxtextlength 512

/* type definistions: Screen, Log, DCC CHAT */
#define OUT_S    1
#define OUT_L    2
#define OUT_D    4

/* where would we be without these? */
#define max2(a,b) ( (a > b) ? a : b )
#define min2(a,b) ( (a < b) ? a : b )
#define max3(a,b,c) ( max2(a,max2(b,c)) )
#define min3(a,b,c) ( min2(a,min2(b,c)) )
#define between(min,a,max) ( max2(min2(a,max),min) )


/* set os specific values */
/* linux */
#if defined(_OS_Linux_x86)   || \
    defined(_OS_Linux_PPC)   || \
    defined(_OS_Linux_alpha) || \
    defined(_OS_Linux_sparc) || \
    defined(_OS_Linux_sparc64)
#define _OS_Linux_ANY
#ifdef _OS_Linux_PPC
#define _GNU_SOURCE
#endif 

/* bsd */
#elif defined(_OS_FreeBSD)   || \
    defined(_OS_OpenBSD)     || \
    defined(_OS_BSDI)        || \
    defined(_OS_BSD_OS)
#define _OS_BSD_ANY

/* sunos */
#elif defined(_OS_SunOS)

/* other */
#else
#error "*** ERROR: This OS Is Not Supported Or You Didn't Run Configure ***"
#endif

#endif _IROFFER_DEFINES
