/**************************************************************************** 
** File: ip.h
**
** Author: Mike Borella
**
** Comments: Generic IP header structure - an attempt at OS independence
**
*****************************************************************************/

#include <sys/types.h>

typedef struct _IPHdr
{
#if defined(WORDS_BIGENDIAN)
  u_int8_t    ip_v:4, 
              ip_hl:4;
#else
  u_int8_t    ip_hl:4, 
              ip_v:4;
#endif
  u_int8_t    ip_tos;
  u_int16_t   ip_len;
  u_int16_t   ip_id;
  u_int16_t   ip_off;
  u_int8_t    ip_ttl;
  u_int8_t    ip_p;
  u_int16_t   ip_csum;
  struct in_addr   ip_src;
  struct in_addr   ip_dst;
} IPHdr;

#define ICMP_NEXT_HEADER 1
#define IP_NEXT_HEADER   4
#define TCP_NEXT_HEADER  6
#define UDP_NEXT_HEADER  17
#define GRE_MEXT_HEADER  47
#define ESP_NEXT_HEADER  50
#define AH_NEXT_HEADER   51

void dump_ip(const u_char *, int);
